/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.curandfixed.notice2cur;

import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class CurAndFixedImpl
extends AbstractCAFImpl
implements ICurAndFixed {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CurAndFixedImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        LoginUtils.login(this.logger);
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        String testServerDate = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        String custid = RequestContextUtils.getBankParameterValue((String)"custid");
        String valDt = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (!StringUtils.isEmpty((String)testServerDate)) {
            valDt = testServerDate;
        }
        curAndFixedInfo.setTranDate(LocalDate.parse(valDt, DateTimeFormatter.ofPattern("yyyyMMdd")).atTime(0, 0));
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSDP20", Sequence.genSequence());
        headr.removeChild("TXN_DT");
        JDomExtUtils.addChildCDData(headr, "TXN_DT", valDt);
        root.addContent((Content)headr);
        Element req = CommonPacker.packComEntity("00000882", curAndFixedInfo.getBatchSeqId());
        body.addContent((Content)req);
        JDomExtUtils.addChildCDData(req, "EBnk_SvAr_ID", custid);
        JDomExtUtils.addChildCDData(req, "Cash_Cst_Trm_AccNo", curAndFixedInfo.getFixedAccNo());
        JDomExtUtils.addChildCDData(req, "Cash_Cst_FixAcc_Nm", curAndFixedInfo.getFixedAccName());
        JDomExtUtils.addChildCDData(req, "Cash_Cst_Crn_AccNo", curAndFixedInfo.getAccNo());
        JDomExtUtils.addChildCDData(req, "Cash_Cst_CrnAcc_Nm", curAndFixedInfo.getAccName());
        String[] reqNbr = curAndFixedInfo.getReqNbrWithoutTag().split("\\|");
        JDomExtUtils.addChildCDData(req, "BkltNo", reqNbr[0]);
        JDomExtUtils.addChildCDData(req, "Dep_DepSeqNo", reqNbr[1]);
        JDomExtUtils.addChildCDData(req, "Drw_Amt", curAndFixedInfo.getAmount());
        JDomExtUtils.addChildCDData(req, "Ntc_Set_Dt", valDt);
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(s);
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%s\u3002", (String)"CurAndFixedImpl_4", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseCode() + bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)s, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String status = JDomExtUtils.getChildText((Element)response, (String)"Txn_St_IndCd");
        String notifyId = JDomExtUtils.getChildText((Element)response, (String)"AdvDep_Set_ID");
        String bsnJrnlNo = JDomExtUtils.getChildText((Element)response, (String)"Bsn_Jrnl_No");
        if ("01".equalsIgnoreCase(status)) {
            curAndFixedInfo.setNotifyId(notifyId);
            curAndFixedInfo.put("bsnJrnlNo", bsnJrnlNo);
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUBMITED, (String)"", (String)"", (String)"");
        } else if ("03".equalsIgnoreCase(status)) {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.FAIL, (String)"", (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        } else {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUBMITED, (String)"", (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        }
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u77e5\u5b58\u6b3e\u652f\u53d6\u901a\u77e5\u5f55\u5165", (String)"CurAndFixedImpl_3", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        CCBHCBankResponse frontResp = CommonParser.getFrontResponse(super.recv(inputStream));
        if (!frontResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"CurAndFixedImpl_5", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), frontResp.getResponseCode() + frontResp.getResponseMessage()));
        }
        return frontResp.getBankMsg();
    }
}

