/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.curandfixed.query;

import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccb.ccip.services.curandfixed.utils.PriCafUtil;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractQueryCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.IQueryCurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryCurAndFixedImpl
extends AbstractQueryCAFImpl
implements IQueryCurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryCurAndFixedImpl.class);

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        LoginUtils.login(logger);
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        String testServerDate = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        String rt = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (!StringUtils.isEmpty((String)testServerDate)) {
            rt = testServerDate;
        }
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSDP09", Sequence.genSequence());
        headr.removeChild("TXN_DT");
        JDomExtUtils.addChildCDData(headr, "TXN_DT", rt);
        root.addContent((Content)headr);
        Element req = CommonPacker.packComEntity("00000882", curAndFixedInfo.getBatchSeqId());
        body.addContent((Content)req);
        JDomExtUtils.addChildCDData(req, "FxDmTfr_Txn_TpCd", "1");
        JDomExtUtils.addChildCDData(req, "Txn_St_IndCd", "01");
        String testQryTime = RequestContextUtils.getBankParameterValue((String)"testQryServerDate");
        if (StringUtils.isEmpty((String)testQryTime)) {
            String date = PriCafUtil.getDateWzFormat(curAndFixedInfo.getTranDate().toLocalDate(), "yyyyMMdd");
            JDomExtUtils.addChildCDData(req, "Enqr_StDt", date);
            JDomExtUtils.addChildCDData(req, "Enqr_CODt", date);
        } else {
            JDomExtUtils.addChildCDData(req, "Enqr_StDt", testQryTime);
            JDomExtUtils.addChildCDData(req, "Enqr_CODt", testQryTime);
        }
        JDomExtUtils.addChildCDData(req, "Cash_Cst_AccNo", curAndFixedInfo.getFixedAccNo());
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(s);
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%s", (String)"QueryCurAndFixedImpl_3", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), bankResp.getResponseCode() + bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)s, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String recNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        if (!"0".equalsIgnoreCase(recNum)) {
            List resultList = response.getChildren("LIST1");
            for (int i = 0; i < resultList.size(); ++i) {
                Element list = (Element)resultList.get(i);
                String bsn_jrnl_no = list.getChildTextTrim("Bsn_Jrnl_No");
                if (!curAndFixedInfo.get("bsnJrnlNo").equalsIgnoreCase(bsn_jrnl_no)) continue;
                String rate = list.getChildTextTrim("IntRt");
                String status = list.getChildTextTrim("Txn_St_IndCd");
                String trm_exDat = list.getChildTextTrim("Trm_ExDat");
                String opendate = list.getChildTextTrim("ValDt");
                if ("01".equalsIgnoreCase(status)) {
                    curAndFixedInfo.setRate(rate);
                    curAndFixedInfo.setEndDate(trm_exDat);
                    curAndFixedInfo.setRateDate(opendate);
                    CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUCCESS, (String)"", (String)"", (String)"");
                } else if ("03".equalsIgnoreCase(status)) {
                    CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.FAIL, (String)"", (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
                } else {
                    CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUBMITED, (String)"", (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
                }
                break;
            }
        } else {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)ResManager.loadKDString((String)"<Check>\u672a\u67e5\u8be2\u5230\u8be5\u7b14\u4e1a\u52a1</Check>", (String)"QueryCurAndFixedImpl_1", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
        }
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSDP09";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001", (String)"QueryCurAndFixedImpl_6", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        CCBHCBankResponse frontResp = CommonParser.getFrontResponse(super.recv(inputStream));
        if (!frontResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"QueryCurAndFixedImpl_4", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), frontResp.getResponseCode() + frontResp.getResponseMessage()));
        }
        return frontResp.getBankMsg();
    }
}

