/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.payment.company;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.CommonQuerypayImpl;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.PaymentUtils;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Content;
import org.jdom2.Element;

public class CompanyQueryPayImpl
extends CommonQuerypayImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CompanyQueryPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSET36";
    }

    public String getBizDesc() {
        return "";
    }

    public String pack(BankPayRequest request) {
        LoginUtils.login(this.logger);
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSET36", Sequence.genSequence());
        root.addContent((Content)headr);
        Element req = CommonPacker.packComEntity("00000882", info.getBankBatchSeqId());
        body.addContent((Content)req);
        JDomExtUtils.addChildCDData(req, "Enqr_StDt", info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(req, "Enqr_CODt", info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(req, "CstPty_Py_Jrnl_No", PaymentUtils.getKD(info));
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        List paymentInfos = request.getPaymentInfos();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\uff0c\u6216\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7ed3\u679c\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return ebBankPayResponse;
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String recNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        if (!"0".equalsIgnoreCase(recNum)) {
            List resultList = response.getChildren("LIST1");
            Map<String, CCBHCBankResponse> bankResponse = this.getParseredPayStatus(resultList);
            for (PaymentInfo info : paymentInfos) {
                CCBHCBankResponse resultCode = bankResponse.get(PaymentUtils.getKD(info));
                if (null == resultCode) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u7ed3\u679c\u660e\u7ec6\u3002", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
                    continue;
                }
                if (resultCode.isSuccess()) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)resultCode.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
                    continue;
                }
                if (resultCode.isSubmited()) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyQueryPayImpl_4", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)resultCode.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyQueryPayImpl_4", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
                    continue;
                }
                if (resultCode.isUnkown()) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyQueryPayImpl_5", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)resultCode.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyQueryPayImpl_5", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyQueryPayImpl_6", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)resultCode.getResponseCode(), (String)resultCode.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\u3002", (String)"CompanyQueryPayImpl_7", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
        }
        ebBankPayResponse.setPaymentInfos(paymentInfos);
        return ebBankPayResponse;
    }

    public Map<String, CCBHCBankResponse> getParseredPayStatus(List<Element> reslutList) {
        HashMap<String, CCBHCBankResponse> parseredMap = new HashMap<String, CCBHCBankResponse>(16);
        for (Element node : reslutList) {
            String sequence = JDomExtUtils.getChildText((Element)node, (String)"CstPty_Py_Jrnl_No");
            String resultCode = JDomExtUtils.getChildText((Element)node, (String)"CshMgt_Txn_Rslt_Cd");
            String errorMsg = JDomExtUtils.getChildText((Element)node, (String)"Err_Inf");
            String errorCode = JDomExtUtils.getChildText((Element)node, (String)"CshMgt_Err_Cd");
            CCBHCBankResponse response = new CCBHCBankResponse();
            response.setBankMsg(errorMsg);
            response.setResponseCode(errorCode);
            response.setResponseMessage(errorMsg);
            if ("1".equals(resultCode)) {
                response.setSuccess(true);
                response.setUnkown(false);
                response.setSubmited(false);
            } else if ("2".equals(resultCode)) {
                response.setSuccess(false);
                response.setUnkown(false);
                response.setSubmited(false);
            } else if ("3".equals(resultCode)) {
                response.setSubmited(true);
                response.setUnkown(false);
                response.setSuccess(false);
            } else {
                response.setUnkown(true);
                response.setSuccess(false);
                response.setSubmited(false);
            }
            parseredMap.put(sequence, response);
        }
        return parseredMap;
    }
}

