/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.payment.individual;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.CommonQueryPayPageImpl;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class IndividualQueryPayImpl
extends CommonQueryPayPageImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(IndividualQueryPayImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CLP1055";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"CCB_CCIP_\u94f6\u4f01\u76f4\u8054\u5ba2\u6237\u4ea4\u6613\u63a5\u53e3\u8bf4\u660e_\u4ee3\u6536\u4ee3\u4ed8_V1.0_20160728.pdf", (String)"IndividualQueryPayImpl_0", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        LoginUtils.login(this.logger);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element req = JDomExtUtils.addChild((Element)body, (String)"request");
        Element header = CommonPacker.packCommonHeader("P1CLP1055", Sequence.genSequence(), "", this.getCurrentPage());
        root.addContent((Content)header);
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        JDomExtUtils.addChildCDData(req, "Txn_SN", info.getBankBatchSeqId());
        JDomExtUtils.addChildCDData(req, "EBnk_SvAr_ID", RequestContextUtils.getBankParameterValue((String)"custid"));
        JDomExtUtils.addChildCDData(req, "EtrUnt_ID", "");
        JDomExtUtils.addChildCDData(req, "VchID", "");
        JDomExtUtils.addChildCDData(req, "Ret_Rslt_Cd", "1");
        JDomExtUtils.addChildCDData(req, "Fmt_File_TpCd", "0");
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        this.setLastPage(this.isLastPage(responseStr, this.getCurrentPage()));
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        List<PaymentInfo> paymentInfos = request.getPaymentInfos();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\uff0c\u6216\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7ed3\u679c\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"IndividualQueryPayImpl_1", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return ebBankPayResponse;
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String Vchr_St = JDomExtUtils.getChildText((Element)response, (String)"Vchr_St");
        if ("700".equalsIgnoreCase(Vchr_St)) {
            paymentInfos = this.preBatchSameItemCheck(request, Integer.parseInt(this.getCurrentPage()) == 1);
            List INST_GRP = response.getChildren("INST_GRP");
            if (paymentInfos.size() == 1) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualQueryPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)Vchr_St, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualQueryPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
            } else if (CollectionUtil.isNotEmpty((Collection)INST_GRP)) {
                Map<String, BankResponse> resultMap = this.getDetailStatus(INST_GRP);
                for (PaymentInfo paymentInfo : paymentInfos) {
                    StringBuilder key = new StringBuilder();
                    key.append(paymentInfo.getIncomeAccNo()).append(paymentInfo.getIncomeAccName()).append(paymentInfo.getAmount()).append(paymentInfo.getExplanation());
                    BankResponse bankResponse = resultMap.get(key.toString());
                    if (bankResponse == null) {
                        key.append("KD_").append(paymentInfo.getBankBatchSeqId());
                        this.logger.info("\u589e\u52a0\u4e86KD\u6807\u8bc6\u5339\u914d\u7684\u5b57\u7b26\u4e32\uff1a{}", (Object)key.toString());
                        bankResponse = resultMap.get(key.toString());
                    }
                    if (bankResponse == null) continue;
                    this.handlePayStatus(paymentInfo, Vchr_St, bankResponse.getResponseCode(), bankResponse.getResponseMessage());
                }
                this.processingBankItemDataHandler(INST_GRP, Vchr_St);
                if (this.isLastPage()) {
                    PayStatusMatchUtil.backBatchSameItemHandler(paymentInfos, (boolean)false, (boolean)true);
                }
            } else {
                this.logger.info("\u54cd\u5e94\u62a5\u6587\u4e2dINST_GRP\u8282\u70b9\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0\u4ed8\u6b3e\u72b6\u6001");
            }
        } else if ("800".equalsIgnoreCase(Vchr_St)) {
            List INST_GRP = response.getChildren("INST_GRP");
            if (CollectionUtil.isEmpty((Collection)INST_GRP)) {
                String RDsc = JDomExtUtils.getChildText((Element)response, (String)"RDsc");
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)Vchr_St, (String)RDsc);
            } else {
                paymentInfos = this.preBatchSameItemCheck(request, Integer.parseInt(this.getCurrentPage()) == 1);
                Map<String, BankResponse> resultMap = this.getDetailStatus(INST_GRP);
                for (PaymentInfo paymentInfo : paymentInfos) {
                    StringBuilder key = new StringBuilder();
                    key.append(paymentInfo.getIncomeAccNo()).append(paymentInfo.getIncomeAccName()).append(paymentInfo.getAmount()).append(paymentInfo.getExplanation());
                    BankResponse bankResponse = resultMap.get(key.toString());
                    if (bankResponse == null) {
                        key.append("KD_").append(paymentInfo.getBankBatchSeqId());
                        this.logger.info("\u589e\u52a0\u4e86KD\u6807\u8bc6\u5339\u914d\u7684\u5b57\u7b26\u4e32\uff1a{}", (Object)key.toString());
                        bankResponse = resultMap.get(key.toString());
                    }
                    if (bankResponse == null) continue;
                    this.handlePayStatus(paymentInfo, Vchr_St, bankResponse.getResponseCode(), bankResponse.getResponseMessage());
                }
                this.processingBankItemDataHandler(INST_GRP, Vchr_St);
                if (this.isLastPage()) {
                    PayStatusMatchUtil.backBatchSameItemHandler(paymentInfos, (boolean)false, (boolean)true);
                }
            }
        } else if ("901".equalsIgnoreCase(Vchr_St) || "902".equalsIgnoreCase(Vchr_St) || "903".equalsIgnoreCase(Vchr_St) || "904".equalsIgnoreCase(Vchr_St) || "200".equalsIgnoreCase(Vchr_St) || "400".equalsIgnoreCase(Vchr_St) || "401".equalsIgnoreCase(Vchr_St)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"IndividualQueryPayImpl_4", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)Vchr_St, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u52a1\u7cfb\u7edf\u5df2\u5904\u7406\u3002", (String)"IndividualQueryPayImpl_6", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)Vchr_St, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
        }
        ebBankPayResponse.setPaymentInfos(paymentInfos);
        return ebBankPayResponse;
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request, boolean isFirstPage) {
        List paymentInfos = request.getPaymentInfos();
        if (isFirstPage) {
            paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
            request.setPaymentInfos(paymentInfos);
            PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)true);
        }
        return paymentInfos;
    }

    public Map<String, BankResponse> getDetailStatus(List<Element> list) {
        HashMap<String, BankResponse> map = new HashMap<String, BankResponse>(16);
        for (Element element : list) {
            String TrdPCt_AccNo = JDomExtUtils.getChildText((Element)element, (String)"TrdPCt_AccNo");
            String TrdPCt_Nm = JDomExtUtils.getChildText((Element)element, (String)"TrdPCt_Nm");
            String SRP_TxnAmt = JDomExtUtils.getChildText((Element)element, (String)"SRP_TxnAmt");
            String SCSP_Smy_Dsc = JDomExtUtils.getChildText((Element)element, (String)"SCSP_Smy_Dsc");
            StringBuilder sb = new StringBuilder();
            try {
                sb.append(TrdPCt_AccNo).append(TrdPCt_Nm).append(new BigDecimal(SRP_TxnAmt).setScale(2).toString()).append(SCSP_Smy_Dsc);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91d1\u989d\u5fc5\u987b\u662f\u4e24\u4f4d\u5c0f\u6570\u3002", (String)"IndividualQueryPayImpl_7", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
            }
            String SCSP_Txn_StCd = JDomExtUtils.getChildText((Element)element, (String)"SCSP_Txn_StCd");
            String Err_Rsn = JDomExtUtils.getChildText((Element)element, (String)"Err_Rsn");
            BankResponse bankResponse = new BankResponse();
            bankResponse.setResponseCode(SCSP_Txn_StCd);
            bankResponse.setResponseMessage(Err_Rsn);
            map.put(sb.toString(), bankResponse);
        }
        return map;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element response = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String TOTAL_PAGE = response.getChildTextTrim("TOTAL_PAGE");
        int total_page = Integer.parseInt(TOTAL_PAGE);
        int page = Integer.parseInt(pageTag);
        return page >= total_page;
    }

    public void processingBankItemDataHandler(List<Element> elementList, String type) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = this.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String SCSP_Txn_StCd = JDomExtUtils.getChildText((Element)element, (String)"SCSP_Txn_StCd");
                    String Err_Rsn = JDomExtUtils.getChildText((Element)element, (String)"Err_Rsn");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, type, SCSP_Txn_StCd, Err_Rsn);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public PaymentInfo handlePayStatus(PaymentInfo tempInfo, String type, String SCSP_Txn_StCd, String Err_Rsn) {
        if ("700".equals(type)) {
            if ("2".equals(SCSP_Txn_StCd)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)SCSP_Txn_StCd, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualQueryPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
            } else if ("3".equals(SCSP_Txn_StCd)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)SCSP_Txn_StCd, (String)Err_Rsn);
            } else if ("1".equals(SCSP_Txn_StCd) || "0".equals(SCSP_Txn_StCd)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)SCSP_Txn_StCd, (String)Err_Rsn);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)SCSP_Txn_StCd, (String)Err_Rsn);
            }
        } else if ("800".equals(type)) {
            if ("3".equals(SCSP_Txn_StCd)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)SCSP_Txn_StCd, (String)Err_Rsn);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)SCSP_Txn_StCd, (String)Err_Rsn);
            }
        }
        return tempInfo;
    }

    private String getBankDataKey(Element element) {
        String[] expArray;
        String SCSP_Smy_Dsc;
        String TrdPCt_AccNo = JDomExtUtils.getChildText((Element)element, (String)"TrdPCt_AccNo");
        String TrdPCt_Nm = JDomExtUtils.getChildText((Element)element, (String)"TrdPCt_Nm");
        String SRP_TxnAmt = JDomExtUtils.getChildText((Element)element, (String)"SRP_TxnAmt");
        String explanation = SCSP_Smy_Dsc = JDomExtUtils.getChildText((Element)element, (String)"SCSP_Smy_Dsc");
        if (!StringUtils.isEmpty((String)SCSP_Smy_Dsc) && SCSP_Smy_Dsc.contains("KD_") && (expArray = SCSP_Smy_Dsc.split("KD_")).length > 1) {
            explanation = expArray[0];
        }
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(TrdPCt_AccNo).append(TrdPCt_Nm).append(new BigDecimal(SRP_TxnAmt).setScale(2).toString()).append(explanation);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91d1\u989d\u5fc5\u987b\u662f\u4e24\u4f4d\u5c0f\u6570\u3002", (String)"IndividualQueryPayImpl_7", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
        }
        return buffer.toString();
    }
}

