/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.ecny.service.payment.etoe;

import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.ecny.service.ABC_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CMRB32";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u91d1\u878d\u7c7b\u4ea4\u6613\u7ed3\u679c\u67e5\u8bc1\u3002", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ABC_DC_Packer.createABCRoot4New("CMRB32");
        Element dcep = JDomUtils.addChild((Element)root, (String)"Dcep");
        JDomUtils.addChild((Element)dcep, (String)"reqSeqNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        JDomUtils.addChild((Element)dcep, (String)"vfReqDate", (String)((PaymentInfo)paymentInfos.get(0)).getLastSubmitTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        if (!"0000".equals(rspCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element Dcep = root.getChild("Dcep");
        String transStatus = Dcep.getChildText("transStatus");
        String retCode = Dcep.getChildText("retCode");
        String info = Dcep.getChildText("info");
        if ("SUCCESS".equals(transStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), (String)retCode, (String)info);
        } else if ("FAIL".equals(transStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), (String)retCode, (String)info);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-abc-ecny", (Object[])new Object[0]), (String)retCode, (String)info);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

