/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.services.balance;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        EBBankBalanceResponse balanceRsp = new EBBankBalanceResponse();
        BalanceInfo balanceInfo = new BalanceInfo();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element body = ebenk.getChild("Body");
        Element list = body.getChild("List");
        Element row = list.getChild("Row");
        String retcode = row.getChildText("ReturnCode");
        if (!"000000".equalsIgnoreCase(retcode)) {
            String retMessage = row.getChildText("ReturnMsg");
            String resMsg = ShowTipUtil.getResponseErrorTips((String)retcode, (String)retMessage);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        String accNo = row.getChildText("AcNo");
        String balance = row.getChildText("Balance");
        String availBl = row.getChildText("AvailBal");
        BalanceUtil.setBankAcnt((BalanceInfo)balanceInfo, (List)rqst.getBankAcntList(), (String)accNo);
        BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)balance);
        BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)availBl);
        balanceInfo.setBankCurrency(rqst.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceRsp.setBalances(Collections.singletonList(balanceInfo));
        return balanceRsp;
    }
}

