/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xib.dc.service.balace;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ifspesi/dbe/api");
        factory.setHttpHeader("Content-Type", "text/json");
        factory.setHttpHeader("Accept-Charset", "GBK");
    }

    public String getDeveloper() {
        return "567";
    }

    public String getBizCode() {
        return "IESI109020";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest req) {
        BankAcnt bankAcnt = req.getAcnt();
        JsonObject body = new JsonObject();
        body.addProperty("accountNo", bankAcnt.getAccNo());
        body.addProperty("startDate", req.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        body.addProperty("endDate", req.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        String reqstMsg = XMB_Packer.createHeadRoot("IESI109020", body);
        return XMB_Packer.sign(reqstMsg);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest req, String rspStr) {
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        BankResponse rsp = XMB_Parser.paseHeadRoot(rspStr);
        logger.info("\u94f6\u884c\u8fd4\u56de\u7801\u4e3a" + rsp.getResponseCode() + "\uff0c\u89e3\u6790\u4f59\u989d\u6210\u529f\uff01");
        if (!"000000".equalsIgnoreCase(rsp.getResponseCode()) && !"00000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s\uff1b\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        bankBalanceResponse.setBalances(this.getBalance(req, rspStr));
        logger.info("\u94f6\u884c\u8fd4\u56de\u7801\u4e3a" + rsp.getResponseCode() + "\uff0c\u89e3\u6790\u4f59\u989d\u6210\u529f\uff01");
        return bankBalanceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BalanceInfo> getBalance(BankBalanceRequest req, String rspStr) {
        ArrayList<BalanceInfo> result = new ArrayList<BalanceInfo>(1);
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(rspStr).getAsJsonObject();
        JsonObject body = jsonObject.get("body").getAsJsonObject();
        JsonElement balanceInfoList = body.get("balanceInfoList");
        if (balanceInfoList == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u3010\u91d1\u989d\u5217\u8868\u3011\u7f3a\u5931", (String)"", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]));
        }
        JsonArray list = balanceInfoList.getAsJsonArray();
        for (int i = 0; i < list.size(); ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            try {
                JsonObject item = list.get(i).getAsJsonObject();
                String bal = item.get("acctBal").getAsString();
                String d = item.get("balDate").getAsString();
                String currency = item.get("currency").getAsString();
                String accountNo = item.get("accountNo").getAsString();
                this.setBankAcnt(balanceInfo, req.getBankAcntList(), accountNo);
                this.setCurrentBalance(balanceInfo, bal);
                this.setBalanceDateTime(balanceInfo, d + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                this.setBankCurrency(balanceInfo, req.getBankCurrency(), currency);
                continue;
            }
            catch (NullPointerException e) {
                balanceInfo.setError("Balance Data Error");
                continue;
            }
            finally {
                result.add(balanceInfo);
            }
        }
        return result;
    }

    public LocalDate limitDate() {
        return null;
    }
}

