/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.ecny.service.ecny.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.ecny.service.ecny.EcnyUtil;
import kd.ebg.aqap.banks.cmb.ecny.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.ecny.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.ecny.util.MsgParser;
import kd.ebg.aqap.banks.cmb.ecny.util.PostUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        List bankAcntList = request.getBankAcntList();
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        EBBankBalanceResponse response = null;
        for (BankAcnt bankAcnt : bankAcntList) {
            try {
                request.getHeader().setAcnt(bankAcnt);
                response = this.doBiz(request);
                balanceInfos.addAll(response.getBalances());
            }
            catch (EBServiceException e) {
                logger.info("\u6570\u5b57\u94b1\u5305\u4f59\u989d\u67e5\u8be2\u51fa\u9519\uff1a", (Object)e);
                BalanceInfo balanceInfo = new BalanceInfo();
                balanceInfo.setBankAcnt(bankAcnt);
                balanceInfo.setBankCurrency(request.getBankCurrency());
                balanceInfo.setError(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u5b57\u94b1\u5305\u4f59\u989d\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1a%s", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-cmb-ecny", (Object[])new Object[0]), e.getCause()));
                balanceInfos.add(balanceInfo);
            }
        }
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceRequest rqst) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);
        BankAcnt acnt = rqst.getAcnt();
        JSONObject ntqacinfx = new JSONObject();
        ntqacinfx.put("walletId", (Object)rqst.getAcnt().getAccNo());
        ntqacinfx.put("clientId", (Object)EcnyUtil.getCilentId(acnt.getAccNo()));
        JSONArray array = new JSONArray();
        array.add((Object)ntqacinfx);
        JSONObject body = new JSONObject();
        body.put("BDMTRSBAX1", (Object)array);
        String bizCode = "WALLETBALANCE";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);
        String res = MsgParser.getReceMsg(rspStr, logger);
        return this.parseEcny(rqst, res);
    }

    public EBBankBalanceResponse parseEcny(BankBalanceRequest rqst, String res) {
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%S\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-cmb-ecny", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntqacinfz = body.getJSONArray("BDMTRSBAZ1");
        BalanceInfo[] balances = new BalanceInfo[1];
        for (int i = 0; i < ntqacinfz.size(); ++i) {
            JSONObject detail = ntqacinfz.getJSONObject(i);
            String accnbr = detail.getString("walletId");
            String avlblv = detail.getString("availableBalance");
            String onlblv = detail.getString("updatedBal");
            if (StringUtils.isEmpty((String)onlblv)) {
                ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-cmb-ecny", (Object[])new Object[0]);
            }
            balances[0] = new BalanceInfo();
            balances[0].setCurrentBalance(new BigDecimal(onlblv));
            BankAcnt bankAcnt = new BankAcnt();
            balances[0].setBankAcnt(bankAcnt);
            balances[0].setBankCurrency(rqst.getBankCurrency());
            LocalDateTime localDateTime = LocalDateTime.now();
            balances[0].setBalanceDateTime(localDateTime);
            bankAcnt.setAccNo(accnbr);
            balances[0].setAvailableBalance(new BigDecimal(avlblv));
        }
        ArrayList balanceInfoList = new ArrayList(balances.length);
        Collections.addAll(balanceInfoList, balances);
        return new EBBankBalanceResponse(balanceInfoList);
    }

    public String getDeveloper() {
        return "simon_wx";
    }

    public String getBizCode() {
        return "WALLETBALANCE";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94b1\u5305\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-cmb-ecny", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean match(BankBalanceRequest request) {
        return true;
    }
}

