/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.util;

import java.time.LocalDateTime;
import kd.ebg.aqap.banks.cexim.dc.util.FileInfoNode;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class CommonPacker {
    public static Element createSystemHead(String transCode) {
        return CommonPacker.createSystemHead(transCode, Sequence.gen18Sequence(), "", "", "");
    }

    public static Element createSystemHead(String transCode, String size, String pageNo, String stsTraceId) {
        return CommonPacker.createSystemHead(transCode, Sequence.gen18Sequence(), size, pageNo, stsTraceId);
    }

    public static Element packCommonHeader(String sysTXCode, String sequence, String traceID, String nextPage) {
        Element root = new Element("Transaction_Header");
        JDomExtUtils.addChildCDData(root, "SYS_TX_CODE", sysTXCode);
        JDomExtUtils.addChildCDData(root, "SYS_MSG_LEN", "0123456789");
        LocalDateTime now = LocalDateTime.now();
        JDomExtUtils.addChildCDData(root, "SYS_REQ_TIME", LocalDateUtil.formatDate((LocalDateTime)now, (String)"yyyyMMddhhmmssSSS"));
        JDomExtUtils.addChildCDData(root, "SYS_TX_VRSN", "01");
        JDomExtUtils.addChildCDData(root, "TXN_DT", LocalDateUtil.formatDate((LocalDateTime)now, (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData(root, "TXN_TM", LocalDateUtil.formatDate((LocalDateTime)now, (String)"hhmmss"));
        JDomExtUtils.addChildCDData(root, "TXN_STFF_ID", EBContext.getContext().getParameter().getBankParameter("cust_no"));
        JDomExtUtils.addChildCDData(root, "MULTI_TENANCY_ID", "CN000");
        JDomExtUtils.addChildCDData(root, "LNG_ID", "zh-cn");
        JDomExtUtils.addChildCDData(root, "REC_IN_PAGE", "100");
        JDomExtUtils.addChildCDData(root, "PAGE_JUMP", nextPage);
        JDomExtUtils.addChildCDData(root, "STS_TRACE_ID", traceID);
        JDomExtUtils.addChildCDData(root, "CHNL_CUST_NO", EBContext.getContext().getParameter().getBankParameter("cust_id"));
        JDomExtUtils.addChildCDData(root, "IttParty_Jrnl_No", sequence);
        String ip = EBContext.getContext().getParameter().getBankParameter("ip");
        JDomExtUtils.addChildCDData(root, "Txn_Itt_IP_Adr", ip);
        return root;
    }

    public static Element packCommonHeader(String sysTXCode, String sequence) {
        return CommonPacker.packCommonHeader(sysTXCode, sequence, "", "1");
    }

    public static Element createSystemHead(String transCode, String sequence, String size, String pageNo, String stsTraceId) {
        Element systemHead = new Element("Transaction_Header");
        JDomExtUtils.addChildCDData(systemHead, "SYS_TX_CODE", transCode);
        JDomExtUtils.addChildCDData(systemHead, "SYS_MSG_LEN", "0123456789");
        LocalDateTime now = LocalDateTime.now();
        JDomExtUtils.addChildCDData(systemHead, "SYS_REQ_TIME", LocalDateUtil.formatDate((LocalDateTime)now, (String)"yyyyMMddhhmmssSSS"));
        JDomExtUtils.addChildCDData(systemHead, "SYS_TX_VRSN", "01");
        JDomExtUtils.addChildCDData(systemHead, "TXN_DT", LocalDateUtil.formatDate((LocalDateTime)now, (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData(systemHead, "TXN_TM", LocalDateUtil.formatDate((LocalDateTime)now, (String)"hhmmss"));
        JDomExtUtils.addChildCDData(systemHead, "TXN_STFF_ID", EBContext.getContext().getParameter().getBankParameter("cust_no"));
        JDomExtUtils.addChildCDData(systemHead, "MULTI_TENANCY_ID", "CN000");
        JDomExtUtils.addChildCDData(systemHead, "LNG_ID", "zh-cn");
        JDomExtUtils.addChildCDData(systemHead, "STS_TRACE_ID", stsTraceId);
        JDomExtUtils.addChildCDData(systemHead, "CHNL_CUST_NO", EBContext.getContext().getParameter().getBankParameter("cust_id"));
        JDomExtUtils.addChildCDData(systemHead, "IttParty_Jrnl_No", sequence);
        String ip = EBContext.getContext().getParameter().getBankParameter("ip");
        JDomExtUtils.addChildCDData(systemHead, "Txn_Itt_IP_Adr", ip);
        JDomExtUtils.addChildCDData(systemHead, "REC_IN_PAGE", size);
        JDomExtUtils.addChildCDData(systemHead, "PAGE_JUMP", pageNo);
        return systemHead;
    }

    public static Element packFileEntity(Element request, FileInfoNode fileInfoNode, String fileName) {
        Element FILE_LIST_PACK = JDomExtUtils.addChild((Element)request, (String)"FILE_LIST_PACK");
        JDomExtUtils.addChildCDData(FILE_LIST_PACK, "FILE_NUM", "1");
        Element FILE_INFO = JDomExtUtils.addChild((Element)FILE_LIST_PACK, (String)"FILE_INFO");
        JDomExtUtils.addChildCDData(FILE_INFO, "FILE_NAME", fileName);
        JDomExtUtils.addChildCDData(FILE_INFO, "Msg_Smy", fileInfoNode.getMd5());
        return request;
    }

    public static Element packInfoComEntity() {
        return CommonPacker.packComEntity("00000058");
    }

    public static Element packPayComEntity() {
        return CommonPacker.packComEntity("00000057");
    }

    public static Element packPayComEntity(String sequence) {
        return CommonPacker.packComEntity("00000057", sequence);
    }

    public static Element packComEntity(String proCode) {
        return CommonPacker.packComEntity(proCode, Sequence.gen18Sequence());
    }

    public static Element packComEntity(String proCode, String sequence) {
        return CommonPacker.packComEntity(proCode, "000000000000000", "000000000000000", "", sequence, "01");
    }

    public static Element packComEntity(String proCode, String schlNo, String fwctlNodeID, String fileName, String sequence, String functionCode) {
        IParameter parameter = EBContext.getContext().getParameter();
        Element root = new Element("request");
        JDomExtUtils.addChildCDData(root, "ASPD_ECD", proCode);
        JDomExtUtils.addChildCDData(root, "SChl_No", schlNo);
        JDomExtUtils.addChildCDData(root, "FwCtl_Node_ID", fwctlNodeID);
        JDomExtUtils.addChildCDData(root, "IttParty_Bsn_Dt", LocalDateUtil.formatDate((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMdd"));
        String grpid = parameter.getBankParameter("grp_id");
        JDomExtUtils.addChildCDData(root, "Grp_ID", StringUtils.isEmpty((String)grpid) ? "" : grpid);
        JDomExtUtils.addChildCDData(root, "Cst_ID", parameter.getBankParameter("cst_id"));
        JDomExtUtils.addChildCDData(root, "Prim_AR_No", parameter.getBankParameter("primar_no"));
        JDomExtUtils.addChildCDData(root, "Root_Node_PdAr_ID", "");
        JDomExtUtils.addChildCDData(root, "PdAr_ID", "");
        JDomExtUtils.addChildCDData(root, "SvM24Hr_Ind", "0");
        JDomExtUtils.addChildCDData(root, "Tmzon_ECD", "08");
        JDomExtUtils.addChildCDData(root, "Rqs_Upload_File_Nm", fileName);
        JDomExtUtils.addChildCDData(root, "Cmpt_Ent_ID", "0000CN000");
        JDomExtUtils.addChildCDData(root, "WF_BIZ_ID", sequence);
        JDomExtUtils.addChildCDData(root, "WF_MNPLT_TP", functionCode);
        JDomExtUtils.addChildCDData(root, "WF_FCN_ID", "");
        JDomExtUtils.addChildCDData(root, "CCstTr_ID", parameter.getBankParameter("ccsttr_id"));
        JDomExtUtils.addChildCDData(root, "CCstTrNdID", parameter.getBankParameter("ccsttrndd_id"));
        return root;
    }
}

