/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzrcb.dc.service.payment.inner;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzrcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.inner.CompanyPayQueryImpl;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.inner.PackPay;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.inner.PayParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    PackPay payPacker = new PackPay();
    PayParser payParser = new PayParser();

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyPayQueryImpl.class;
    }

    public String getDeveloper() {
        return "kiki";
    }

    public String getBizCode() {
        return "YQ265";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        boolean isAllocation = "pay_for_capital_allocation".equals(paymentInfo.getSubBizType()) && "Company".equals(BankBusinessConfig.getAllocationType());
        boolean isPay = "pay".equals(paymentInfo.getSubBizType());
        return (isAllocation || isPay) && paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        int size = request.getPaymentInfos().size();
        return this.payPacker.packPay(request.getPaymentInfos().toArray(new PaymentInfo[size]));
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        int size = request.getPaymentInfos().size();
        return this.payParser.parsePay(request.getPaymentInfos().toArray(new PaymentInfo[size]), responseStr);
    }
}

