/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.balance;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.area.CMBStore;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.banks.cmb.dc.service.balance.HisBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        return this.packNormalTodayBalance(request);
    }

    private String packNormalTodayBalance(BankBalanceRequest request) {
        BankAcnt acnt = (BankAcnt)request.getBankAcntList().get(0);
        String accNo = acnt.getAccNo();
        String branchNo = CMBStore.getInstance().getAreaCode(acnt);
        Element root = CMB_DC_Packer.packRoot("GetAccInfo");
        Element sdkacinfx = JDomUtils.addChild((Element)root, (String)"SDKACINFX");
        JDomUtils.addChild((Element)sdkacinfx, (String)"BBKNBR", (String)branchNo);
        JDomUtils.addChild((Element)sdkacinfx, (String)"ACCNBR", (String)accNo);
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        BankAcnt acnt = request.getHeader().getAcnt();
        return this.parseNormalTodayBalance(request, responseStr);
    }

    private EBBankBalanceResponse parseNormalTodayBalance(BankBalanceRequest rqst, String rspStr) {
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u62db\u884c\u54cd\u5e94\u7801:%1$s;\u51fa\u9519\u539f\u56e0\u4e3a:%2$s\u3002", (String)"TodayBalanceImpl_7", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), headRsp.getResponseCode(), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element ntqacinfz = root.getChild("NTQACINFZ");
        String accNo = ntqacinfz.getChildTextTrim("ACCNBR");
        String balance = ntqacinfz.getChildTextTrim("ONLBLV");
        String usableBalance = ntqacinfz.getChildTextTrim("AVLBLV");
        String currType = ntqacinfz.getChildTextTrim("CCYNBR");
        String accBalance = ntqacinfz.getChildTextTrim("ACCBLV");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo info = new BalanceInfo();
        balances.add(info);
        String intcod = ntqacinfz.getChildTextTrim("INTCOD");
        if (!StringUtils.isEmpty((String)intcod) && "S".equals(intcod) && BankBusinessConfig.isChooseACCBLV()) {
            info.setAvailableBalance(new BigDecimal(accBalance));
            info.setCurrentBalance(new BigDecimal(accBalance));
            info.setLastDayAvlBalance(new BigDecimal(accBalance));
        } else {
            logger.info("\u89e3\u6790\u5230\u62db\u884c\u8fd4\u56de\u7684'\u5f53\u524d\u4f59\u989d'\u4e3a" + balance);
            info.setCurrentBalance(new BigDecimal(balance));
            logger.info("\u89e3\u6790\u5230\u62db\u884c\u8fd4\u56de\u7684'\u4e0a\u65e5\u4f59\u989d'\u4e3a" + accBalance);
            info.setLastDayAvlBalance(new BigDecimal(accBalance));
            logger.info("\u89e3\u6790\u5230\u62db\u884c\u8fd4\u56de\u7684'\u53ef\u7528\u4f59\u989d'\u4e3a" + usableBalance);
            info.setAvailableBalance(new BigDecimal(usableBalance));
        }
        if ("S".equals(intcod) && !BankBusinessConfig.lastDayBalIsAccblv()) {
            logger.info("\u6628\u65e5\u4f59\u989d\u53d6\u503c\u914d\u7f6e\u4e3aBALAMT\uff0c\u5f00\u59cb\u67e5\u8be2\u5386\u53f2\u4f59\u989d");
            rqst.setStartDate(LocalDate.now().minusDays(1L));
            rqst.setEndDate(LocalDate.now().minusDays(1L));
            HisBalanceImpl hisBalance = new HisBalanceImpl();
            EBBankBalanceResponse ebBankBalanceResponse = hisBalance.hisBalance(rqst);
            BalanceInfo balanceInfo = (BalanceInfo)ebBankBalanceResponse.getBalances().get(0);
            BigDecimal lastDayAvlBalance = balanceInfo.getCurrentBalance();
            info.setLastDayAvlBalance(lastDayAvlBalance);
        }
        BankAcnt bankAcnt = new BankAcnt();
        info.setBankAcnt(bankAcnt);
        info.setBankCurrency(currType);
        info.setBalanceDateTime(LocalDateTime.now());
        bankAcnt.setAccNo(accNo);
        if (!rqst.getHeader().getBankCurrency().equalsIgnoreCase(currType)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5e01\u79cd(%1$s)\u4e0e\u8d26\u6237\u5b9e\u9645\u5e01\u79cd\u4e0d\u7b26\uff0c\u8bf7\u4ee5'%2$s'\u4f5c\u4e3a\u4f59\u989d\u67e5\u8be2\u7684\u6761\u4ef6", (String)"TodayBalanceImpl_8", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), CurrencyUtils.getCurrencyName((String)rqst.getHeader().getBankCurrency()), CurrencyUtils.getCurrencyName((String)currType)));
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "GetAccInfo";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

