/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.detail;

import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.area.CMBStore;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrencyImpl
extends AbstractBalanceImpl
implements IBalance {
    private static Logger logger = LoggerFactory.getLogger(CurrencyImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        return this.doBiz(request);
    }

    public String pack(BankBalanceRequest request) {
        String province;
        BankAcnt acnt = request.getHeader().getAcnt();
        String accNo = acnt.getAccNo();
        String branchNo = acnt.getAreaCode();
        if (StringUtils.isEmpty((String)branchNo) && !StringUtils.isEmpty((String)(province = acnt.getProvince()))) {
            branchNo = CMBStore.getInstance().matchProvince(province).getBranchBankCode();
        }
        Element root = CMB_DC_Packer.packRoot("GetAccInfo");
        Element sdkacinfx = JDomUtils.addChild((Element)root, (String)"SDKACINFX");
        JDomUtils.addChild((Element)sdkacinfx, (String)"BBKNBR", (String)branchNo);
        JDomUtils.addChild((Element)sdkacinfx, (String)"ACCNBR", (String)accNo);
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u62db\u884c\u54cd\u5e94\u7801:%1$s;\u51fa\u9519\u539f\u56e0\u4e3a:%2$s\u3002", (String)"CurrencyImpl_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), headRsp.getResponseCode(), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element ntqacinfz = root.getChild("NTQACINFZ");
        String accNo = ntqacinfz.getChildTextTrim("ACCNBR");
        String currType = ntqacinfz.getChildTextTrim("CCYNBR");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo info = new BalanceInfo();
        balances.add(info);
        info.setBankCurrency(currType);
        if (!request.getHeader().getBankCurrency().equalsIgnoreCase(currType)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5e01\u79cd(%1$s)\u4e0e\u8d26\u6237\u5b9e\u9645\u5e01\u79cd\u4e0d\u7b26\uff0c\u8bf7\u4ee5'%2$s'\u4f5c\u4e3a\u4f59\u989d\u67e5\u8be2\u7684\u6761\u4ef6", (String)"CurrencyImpl_6", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), CurrencyUtils.getCurrencyName((String)request.getHeader().getBankCurrency()), CurrencyUtils.getCurrencyName((String)currType)));
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "GetAccInfo";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

