/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.agent;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_PayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.agent.AgentQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AgentPayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AgentQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "Payment";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\u4ee3\u7406\u6e05\u7b97\u7533\u8bf7\u7ecf\u529e", (String)"AgentPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_agentpay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        List paymentInfos = request.getPaymentInfos();
        Element root = CMB_DC_Packer.packRoot("NTOPRAGP");
        Element ntoprmodx = JDomUtils.addChild((Element)root, (String)"NTOPRMODX");
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankDetailSeqID((List)paymentInfos);
        }
        String BUSMOD = context.getParameter().getBankParameter("BUSMOD4AgentPay");
        JDomUtils.addChild((Element)ntoprmodx, (String)"BUSMOD", (String)BUSMOD);
        for (int i = 0; i < paymentInfos.size(); ++i) {
            String dbtbbk = ((PaymentInfo)paymentInfos.get(i)).getAreaCode();
            Element ntopragpx1 = JDomUtils.addChild((Element)root, (String)"NTOPRAGPX1");
            JDomUtils.addChild((Element)ntopragpx1, (String)"YURREF", (String)PaymentUtil.setBankDetailRefID((PaymentInfo)paymentInfos.get(i)));
            if (null != ((PaymentInfo)paymentInfos.get(i)).getBookingTime() && ((PaymentInfo)paymentInfos.get(i)).getBookingTime().isAfter(LocalDateTime.now())) {
                JDomUtils.addChild((Element)ntopragpx1, (String)"EPTDAT", (String)((PaymentInfo)paymentInfos.get(i)).getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                kd.ebg.aqap.business.payment.utils.PaymentUtil.setBookPayFlag((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            }
            JDomUtils.addChild((Element)ntopragpx1, (String)"DBTACC", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)ntopragpx1, (String)"DBTBBK", (String)dbtbbk);
            JDomUtils.addChild((Element)ntopragpx1, (String)"TRSAMT", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)ntopragpx1, (String)"CCYNBR", (String)((PaymentInfo)paymentInfos.get(i)).getCurrency());
            String stlchn = ((PaymentInfo)paymentInfos.get(i)).getUrgent() != false ? "F" : "N";
            JDomUtils.addChild((Element)ntopragpx1, (String)"STLCHN", (String)stlchn);
            JDomUtils.addChild((Element)ntopragpx1, (String)"BNKFLG", (String)(((PaymentInfo)paymentInfos.get(i)).getSameBank() != false ? "Y" : "N"));
            JDomUtils.addChild((Element)ntopragpx1, (String)"CHGFOR", (String)"O");
            JDomUtils.addChild((Element)ntopragpx1, (String)"NUSAGE", (String)StringUtils.substringChinese((String)((PaymentInfo)paymentInfos.get(i)).getExplanation(), (String)encoding, (int)62));
            JDomUtils.addChild((Element)ntopragpx1, (String)"BUSNAR", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
            JDomUtils.addChild((Element)ntopragpx1, (String)"CRTACC", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)ntopragpx1, (String)"CRTNAM", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)ntopragpx1, (String)"CRTADR", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankAddress());
            if (!StringUtils.isEmpty((String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps())) {
                JDomUtils.addChild((Element)ntopragpx1, (String)"BRDNBR", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps());
            }
            JDomUtils.addChild((Element)ntopragpx1, (String)"CRTBNK", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)ntopragpx1, (String)"CRTPVC", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeProvince());
            JDomUtils.addChild((Element)ntopragpx1, (String)"CRTCTY", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCity());
            JDomUtils.addChild((Element)ntopragpx1, (String)"NTFCH1", (String)"");
            JDomUtils.addChild((Element)ntopragpx1, (String)"NTFCH2", (String)"");
            JDomUtils.addChild((Element)ntopragpx1, (String)"CRTSQN", (String)"");
            String bankName = ((PaymentInfo)paymentInfos.get(i)).getBankName();
            JDomUtils.addChild((Element)ntopragpx1, (String)"RMTBNK", (String)(StringUtils.isEmpty((String)bankName) ? ((PaymentInfo)paymentInfos.get(i)).getBankName() : bankName));
        }
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CMB_DC_PayParser.parseAgentPay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

