/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.income;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_PayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.income.IncomeQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IncomeSinglePayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IncomeQueryPayImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u76f4\u63a5\u4ee3\u53d1\u4ee3\u6263;\u4ea4\u6613\u7801\u662fAgentRequest\uff0cN03030\u3002", (String)"IncomeSinglePayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u6263\u4e1a\u52a1", (String)"IncomeSinglePayImpl_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String busmod = RequestContextUtils.getBankParameterValue((String)"BUSMOD4INCOME");
        if (StringUtils.isEmpty((String)busmod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6279\u6263\u4e1a\u52a1\u7684'\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7'", (String)"IncomeSinglePayImpl_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        }
        BigDecimal totalAmt = new BigDecimal("0.00");
        Element root = CMB_DC_Packer.packRoot("AgentRequest");
        Element sdkatsrqx = JDomUtils.addChild((Element)root, (String)"SDKATSRQX");
        JDomUtils.addChild((Element)sdkatsrqx, (String)"BUSCOD", (String)"N03030");
        JDomUtils.addChild((Element)sdkatsrqx, (String)"BUSMOD", (String)busmod);
        JDomUtils.addChild((Element)sdkatsrqx, (String)"C_TRSTYP", (String)ResManager.loadKDString((String)"\u4ee3\u6263\u5176\u4ed6", (String)"IncomeSinglePayImpl_3", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        JDomUtils.addChild((Element)sdkatsrqx, (String)"DBTACC", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)sdkatsrqx, (String)"BBKNBR", (String)((PaymentInfo)paymentInfos.get(0)).getAreaCode());
        Element sum = JDomUtils.addChild((Element)sdkatsrqx, (String)"SUM", (String)"");
        JDomUtils.addChild((Element)sdkatsrqx, (String)"TOTAL", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)sdkatsrqx, (String)"CCYNBR", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        String yurref = PaymentUtil.getBankBatchSeqId((PaymentInfo)paymentInfos.get(0));
        JDomUtils.addChild((Element)sdkatsrqx, (String)"YURREF", (String)yurref);
        JDomUtils.addChild((Element)sdkatsrqx, (String)"MEMO", (String)StringUtils.substringChinese((String)((PaymentInfo)paymentInfos.get(0)).getExplanation(), (String)RequestContextUtils.getCharset(), (int)42));
        JDomUtils.addChild((Element)sdkatsrqx, (String)"GRTFLG", (String)(BankBusinessConfig.isPaymetByAuthorized() ? "Y" : ""));
        for (int i = 0; i < paymentInfos.size(); ++i) {
            ((PaymentInfo)paymentInfos.get(i)).setBankRefID(yurref);
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(0)).getAmount());
            Element sdkatdrqx = JDomUtils.addChild((Element)root, (String)"SDKATDRQX");
            JDomUtils.addChild((Element)sdkatdrqx, (String)"ACCNBR", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)sdkatdrqx, (String)"CLTNAM", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)sdkatdrqx, (String)"TRSAMT", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)sdkatdrqx, (String)"BNKFLG", (String)(((PaymentInfo)paymentInfos.get(i)).is2SameBank() ? "Y" : "N"));
            JDomUtils.addChild((Element)sdkatdrqx, (String)"EACBNK", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)sdkatdrqx, (String)"EACCTY", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCity());
            JDomUtils.addChild((Element)sdkatdrqx, (String)"TRSDSP", (String)"");
        }
        sum.setText(totalAmt.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        CMB_DC_PayParser.parseIndividualPay(paymentInfos, responseStr);
        return new EBBankPayResponse(paymentInfos);
    }
}

