/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.individual;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_PayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.UseConvertor;
import kd.ebg.aqap.banks.cmb.dc.service.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualPayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 30;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return String.format(ResManager.loadKDString((String)"AgentRequest,\u5e76\u7b14\u6570\uff1a%s", (String)"IndividualPayImpl_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), this.getBatchSize());
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getIndividual() != false && paymentInfo.is2Merge() || "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.is2Individual() && UseConvertor.isSalary(paymentInfo) && BankBusinessConfig.isSalary2Individual() && !BankBusinessConfig.isSinglePay() || "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) && BankBusinessConfig.isSalary2Individual() && !BankBusinessConfig.isSinglePay();
    }

    public String pack(BankPayRequest request) {
        String explain;
        String c_trstyp;
        String busmod = EBContext.getContext().getParameter().getBankParameter("BUSMOD4Agent");
        if (StringUtils.isEmpty((String)busmod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u4ee3\u53d1\u4e1a\u52a1\uff08\u5de5\u8d44\u9664\u5916\uff09\u7684'\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7'", (String)"IndividualPayImpl_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        }
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String explanationConfig = "";
        if (paymentInfo.getExplanation() != null && paymentInfo.getExplanation().indexOf("|") != -1) {
            explanationConfig = paymentInfo.getExplanation().substring(paymentInfo.getExplanation().lastIndexOf("|") + 1);
        }
        if (StringUtils.isEmpty((String)(c_trstyp = BankBusinessConfig.getC_TRSTYP(paymentInfo.getAccNo(), explanationConfig)))) {
            c_trstyp = UseConvertor.convert2CMBUseCn(paymentInfo);
        }
        String dbtbbk = paymentInfo.getAreaCode();
        String accNo = paymentInfo.getAccNo();
        String encoding = EBContext.getContext().getCharsetName();
        BigDecimal totalAmt = new BigDecimal("0.00");
        Element root = CMB_DC_Packer.packRoot("AgentRequest");
        Element sdkatsrqx = JDomUtils.addChild((Element)root, (String)"SDKATSRQX");
        JDomUtils.addChild((Element)sdkatsrqx, (String)"BUSCOD", (String)"N03020");
        JDomUtils.addChild((Element)sdkatsrqx, (String)"BUSMOD", (String)busmod);
        JDomUtils.addChild((Element)sdkatsrqx, (String)"C_TRSTYP", (String)c_trstyp);
        JDomUtils.addChild((Element)sdkatsrqx, (String)"DBTACC", (String)accNo);
        JDomUtils.addChild((Element)sdkatsrqx, (String)"BBKNBR", (String)dbtbbk);
        Element sum = JDomUtils.addChild((Element)sdkatsrqx, (String)"SUM", (String)"");
        JDomUtils.addChild((Element)sdkatsrqx, (String)"TOTAL", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)sdkatsrqx, (String)"CCYNBR", (String)paymentInfo.getCurrency());
        String yurref = PaymentUtil.getBankBatchSeqId(paymentInfo);
        JDomUtils.addChild((Element)sdkatsrqx, (String)"YURREF", (String)yurref);
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankBatchSeqID((List)paymentInfos);
        }
        if ((explain = paymentInfo.getExplanation()).indexOf("|") != -1) {
            JDomUtils.addChild((Element)sdkatsrqx, (String)"MEMO", (String)StringUtils.substringChinese((String)explain.substring(0, explain.lastIndexOf("|")), (String)encoding, (int)42));
        } else {
            JDomUtils.addChild((Element)sdkatsrqx, (String)"MEMO", (String)StringUtils.substringChinese((String)explain, (String)encoding, (int)42));
        }
        JDomUtils.addChild((Element)sdkatsrqx, (String)"GRTFLG", (String)(BankBusinessConfig.isPaymetByAuthorized() ? "Y" : ""));
        for (int i = 0; i < paymentInfos.size(); ++i) {
            ((PaymentInfo)paymentInfos.get(i)).setBankRefID(yurref);
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            Element sdkatdrqx = JDomUtils.addChild((Element)root, (String)"SDKATDRQX");
            JDomUtils.addChild((Element)sdkatdrqx, (String)"ACCNBR", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)sdkatdrqx, (String)"CLTNAM", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)sdkatdrqx, (String)"TRSAMT", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)sdkatdrqx, (String)"BNKFLG", (String)(((PaymentInfo)paymentInfos.get(i)).getSameBank() != false ? "Y" : "N"));
            JDomUtils.addChild((Element)sdkatdrqx, (String)"EACBNK", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)sdkatdrqx, (String)"EACCTY", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCity());
            if (paymentInfo.getExplanation().indexOf("|") != -1) {
                JDomUtils.addChild((Element)sdkatdrqx, (String)"TRSDSP", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation().substring(0, ((PaymentInfo)paymentInfos.get(i)).getExplanation().lastIndexOf("|")));
                continue;
            }
            JDomUtils.addChild((Element)sdkatdrqx, (String)"TRSDSP", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
        }
        sum.setText(totalAmt.toString());
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CMB_DC_PayParser.parseIndividualPay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

