/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.srdc.service.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.srdc.Packer;
import kd.ebg.aqap.banks.psbc.srdc.Parser;
import kd.ebg.aqap.banks.psbc.srdc.util.DomHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FixedBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(FixedBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        Element root = Packer.createReqRootElement("1009");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Query_Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Sub_Acct", (String)"");
        JDomUtils.addChild((Element)Param, (String)"StartDate", (String)"");
        JDomUtils.addChild((Element)Param, (String)"EndDate", (String)"");
        JDomUtils.addChild((Element)Param, (String)"House", (String)"");
        JDomUtils.addChild((Element)Param, (String)"House_End_Date", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Remark_State", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equals(protocol) || "HTTP".equals(protocol)) {
            return xmlStr;
        }
        return Packer.createCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.checkResponse(root, ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u67e5\u8be2", (String)"FixedBalanceImpl_0", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        Element param = DomHelper.getChildElementNotNull(root, "Param");
        List recordSet = param.getChildren("RecordSet");
        if (CollectionUtil.isEmpty((Collection)recordSet)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5b9a\u671f\u6237(%s)\u4f59\u989d\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u5b50\u8d26\u6237\u4f59\u989d\u8bb0\u5f55\u4e3a\u7a7a\u3002", (String)"FixedBalanceImpl_8", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]), request.getAcnt().getAccNo()));
        }
        BigDecimal balance = new BigDecimal("0.0");
        for (Element record : recordSet) {
            String balanceStr = record.getChildText("Amount");
            String sub_Sequence = record.getChildText("Sub_Sequence");
            this.logger.info("\u5b9a\u671f\u6237{}\u7684\u5b50\u8d26\u6237{}\u7684\u4f59\u989d\u4e3a{}", new Object[]{request.getAcnt().getAccNo(), sub_Sequence, balanceStr});
            balance = balance.add(new BigDecimal(balanceStr));
        }
        this.logger.info("\u5b9a\u671f\u6237{}\u603b\u4f59\u989d\u4e3a{}", new Object[]{request.getAcnt().getAccNo(), balance});
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setCurrentBalance(BigDecimalHelper.div((BigDecimal)balance, (String)"100.00"));
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceInfo.setBankAcnt(request.getAcnt());
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public boolean match(BankBalanceRequest request) {
        return BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo());
    }

    public void configFactory(ConnectionFactory factory) {
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equals(protocol) || "HTTP".equals(protocol)) {
            String requesturl = RequestContextUtils.getBankParameterValue((String)"exchangeUri");
            factory.setUri(requesturl);
            factory.setHttpHeader("content-type", "application/xml;charset=GBK");
        } else {
            super.configFactory(factory);
            factory.setHttpHeader("Content-Type", "text/xml");
        }
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "1009";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4f59\u989d", (String)"FixedBalanceImpl_6", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]);
    }
}

