/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.srdc.service.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.srdc.Packer;
import kd.ebg.aqap.banks.psbc.srdc.util.DomHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        if (!request.getStartDate().isEqual(request.getEndDate())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u53ea\u652f\u6301\u5355\u65e5\u4f59\u989d\u67e5\u8be2\u3002", (String)"HistoryBalanceImpl_0", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
        }
        if (BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u8d26\u6237\u4e0d\u652f\u6301\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HistoryBalanceImpl_12", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
        }
        Element root = Packer.createReqRootElement("1002");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Query_Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Begin_Date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"Currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equals(protocol) || "HTTP".equals(protocol)) {
            return xmlStr;
        }
        return Packer.createCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element Head = DomHelper.getChildElementNotNull(root, "Head");
        String OpRetCode = DomHelper.getChildTextNotNull(Head, "OpRetCode", ResManager.loadKDString((String)"\u8d26\u6237\u5386\u53f2\u4f59\u989d\u67e5\u8be2 \u8fd4\u56de\u7801", (String)"HistoryBalanceImpl_10", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
        String OpRetMsg = DomHelper.getChildTextNullAsBlank(Head, "OpRetMsg");
        if (!"000000".equals(OpRetCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)OpRetCode, (String)OpRetMsg));
        }
        Element Param = DomHelper.getChildElementNotNull(root, "Param");
        String Balance = Param.getChildText("Balance");
        String Usable_Balance = Param.getChildText("Amt3");
        BalanceInfo balance = new BalanceInfo();
        balance.setBankAcnt(request.getAcnt());
        LocalDate balanceDate = request.getStartDate();
        this.setBalanceDateTime(balance, LocalDateTime.of(balanceDate, LocalTime.now()));
        if (StringUtils.isNotEmpty((String)Usable_Balance)) {
            balance.setAvailableBalance(BigDecimalHelper.div((String)Usable_Balance, (String)"100.00"));
        }
        this.setCurrentBalance(balance, Balance, 100);
        balance.setBankCurrency(request.getBankCurrency());
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        balanceInfos.add(balance);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5386\u53f2\u4f59\u989d\u67e5\u8be2\uff081002\uff09", (String)"HistoryBalanceImpl_9", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HistoryBalanceImpl_1", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equals(protocol) || "HTTP".equals(protocol)) {
            String requesturl = RequestContextUtils.getBankParameterValue((String)"exchangeUri");
            factory.setUri(requesturl);
            factory.setHttpHeader("content-type", "application/xml;charset=GBK");
        } else {
            super.configFactory(factory);
            factory.setHttpHeader("Content-Type", "text/xml");
        }
    }

    public boolean match(BankBalanceRequest request) {
        return !BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo());
    }

    public LocalDate limitDate() {
        return LocalDate.of(1970, 1, 1);
    }

    public int queryDays() {
        return 1;
    }
}

