/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.opa.services.apply;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.opa.utils.CommonUtil;
import kd.ebg.aqap.business.apply.atomic.AbstractQueryApplyImpl;
import kd.ebg.aqap.business.apply.atomic.IQueryApply;
import kd.ebg.aqap.business.apply.bank.BankQueryApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankQueryApplyResponse;
import kd.ebg.aqap.common.constant.ApplyStatusEnum;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryApplyImpl
extends AbstractQueryApplyImpl
implements IQueryApply {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryApplyImpl.class);

    public EBBankQueryApplyResponse doBiz(BankQueryApplyRequest request) {
        EBBankQueryApplyResponse result;
        try {
            String requestStr = this.pack(request);
            Preconditions.checkNotNull((Object)requestStr, (Object)ResManager.loadKDString((String)"\u6253\u5305\u540e\u5f85\u53d1\u9001\u7684\u6570\u636e\u4e0d\u80fd\u4e3anull", (String)"QueryApplyImpl_0", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
            String responseStr = new CommonUtil().sendToBank(this.getBizCode(), requestStr);
            result = this.parse(request, responseStr);
        }
        catch (Exception var14) {
            this.logger.error("\u67e5\u8be2\u7533\u8bf7\u7ed3\u679c\u5931\u8d25", (Throwable)var14);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u7533\u8bf7\u7ed3\u679c\u5931\u8d25", (String)"QueryApplyImpl_1", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]), (Throwable)var14);
        }
        return result;
    }

    public String pack(BankQueryApplyRequest bankQueryApplyRequest) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isEmpty((String)bankQueryApplyRequest.getThirdVoucher())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7b7e\u7ea6\u6d41\u6c34\u53f7", (String)"QueryApplyImpl_2", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
        }
        jsonObject.put("serialNo", (Object)Sequence.gen18Sequence());
        jsonObject.put("signSerialNo", (Object)bankQueryApplyRequest.getThirdVoucher());
        return jsonObject.toJSONString();
    }

    public EBBankQueryApplyResponse parse(BankQueryApplyRequest bankQueryApplyRequest, String responseStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        String code = jsonObject.getString("code");
        String msg = jsonObject.getString("msg");
        EBBankQueryApplyResponse result = new EBBankQueryApplyResponse();
        if (!"0".equals(code)) {
            ApplyStatusEnum applyStatus = ApplyStatusEnum.QUERY_FAIL;
            result.setStatus(applyStatus.getId() + "");
            result.setDesc(msg);
        } else {
            String resultCode = jsonObject.getString("resultCode");
            String resultMsg = jsonObject.getString("resultMsg");
            ApplyStatusEnum applyStatus = this.getApplyStatusEnum(resultCode);
            result.setStatus(applyStatus.getId() + "");
            result.setDesc(applyStatus.getName());
            if (ApplyStatusEnum.FAIL == applyStatus) {
                result.setDesc(resultMsg);
            } else if (ApplyStatusEnum.QUERY_FAIL == applyStatus) {
                StringBuilder desc = new StringBuilder(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u7801\uff1a", (String)"QueryApplyImpl_3", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
                desc.append(resultCode);
                if (StringUtils.isNotEmpty((String)resultMsg)) {
                    desc.append(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"QueryApplyImpl_4", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0])).append(resultMsg);
                }
                result.setDesc(desc.toString());
            }
        }
        result.setThirdVoucher(bankQueryApplyRequest.getThirdVoucher());
        return result;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "/api/dcfirmSAAS/querySaasContract";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u7b7e\u7ea6/\u89e3\u7ea6\u7ed3\u679c", (String)"QueryApplyImpl_5", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
    }

    ApplyStatusEnum getApplyStatusEnum(String resultCode) {
        switch (resultCode) {
            case "1": {
                return ApplyStatusEnum.PENDING_GRANT;
            }
            case "2": {
                return ApplyStatusEnum.FAIL;
            }
            case "3": {
                return ApplyStatusEnum.APPROVAL_PENDING;
            }
            case "4": {
                return ApplyStatusEnum.SUCCESS;
            }
            case "5": {
                return ApplyStatusEnum.FAIL;
            }
        }
        return ApplyStatusEnum.QUERY_FAIL;
    }
}

