/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.opa.services.payment.individual;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.opa.BankBussinessConfig;
import kd.ebg.aqap.banks.boc.opa.services.payment.query.lca0007Impl;
import kd.ebg.aqap.banks.boc.opa.services.utils.BOCRequest;
import kd.ebg.aqap.banks.boc.opa.services.utils.BOCUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class lca0006Impl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return lca0007Impl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5355\u7b14\u4ea4\u6613\uff01", (String)"lca0006Impl_0", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        BOCRequest request = new BOCRequest();
        BOCRequest.MsgBody msgBody = new BOCRequest.MsgBody();
        BankAcnt acnt = bankPayRequest.getAcnt();
        JSONObject data = new JSONObject();
        String triSignId = BankBussinessConfig.getTriSignId(acnt.getAccNo());
        if (StringUtils.isEmpty((String)triSignId)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e09\u65b9\u7b7e\u7ea6ID\u4e3a\u7a7a,\u8bf7\u5148\u8fdb\u884c\u4e09\u65b9\u7b7e\u7ea6\u3002", (String)"lca0006Impl_1", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
        data.put("triSignId", (Object)triSignId);
        data.put("businessId", (Object)paymentInfo.getBankBatchSeqID());
        data.put("payerAcctNum", (Object)paymentInfo.getAccNo());
        data.put("payeeAcctNum", (Object)paymentInfo.getIncomeAccNo());
        data.put("payeeAccountName", (Object)paymentInfo.getIncomeAccName());
        data.put("bocFla", (Object)(paymentInfo.is2SameBank() ? 1 : 0));
        data.put("amount", (Object)paymentInfo.getAmount());
        data.put("currency", (Object)paymentInfo.getCurrency());
        data.put("payType", (Object)0);
        msgBody.setData(data.toJSONString());
        request.setMsgBody(msgBody);
        return BOCUtil.goRequest(request, bankPayRequest.getHeader().getCustomerID());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject data = BOCUtil.handleResponse(s);
        String status = data.getString("status");
        if ("B".equalsIgnoreCase(status) || "7D".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)"", (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.is2Individual();
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/eztdg-framework/igtb/finance/v1/psnRemitConsign");
        factory.setHttpHeader("from_product", "third");
        factory.setHttpHeader("target_product", "IGTBNET-LCA");
        factory.setHttpHeader("Content-type", "application/json");
        factory.setHttpHeader("interaction_id", "o.tdg.igtbnet-lca0006");
    }
}

