/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.payment.allocation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.BankResponseCodeUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ZJRC_DC_Packer.getCommonHeader("100009", Sequence.genSequence());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        JDomUtils.addChild((Element)reqBody, (String)"flowNoType", (String)"1");
        Element flowNoList = JDomUtils.addChild((Element)reqBody, (String)"flowNoList");
        Element row = JDomUtils.addChild((Element)flowNoList, (String)"row");
        JDomUtils.addChild((Element)row, (String)"orderFlowNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"AllocationQueryPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
            Element tranflowResultList = JDomUtils.getChildElement((Element)resBody, (String)"tranflowResultList");
            List rows = tranflowResultList.getChildren("row");
            HashMap<String, BankResponse> infoMap = new HashMap<String, BankResponse>(16);
            for (int i = 0; i < rows.size(); ++i) {
                String orderFlowNo = ((Element)rows.get(i)).getChildTextTrim("orderFlowNo");
                String code = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"state");
                String erroerMsg = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"errorMessage");
                BankResponse bank2Response = new BankResponse();
                bank2Response.setResponseCode(code);
                bank2Response.setResponseMessage(erroerMsg);
                infoMap.put(orderFlowNo, bank2Response);
            }
            this.matchSetPaymentState(infoMap, paymentInfos);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private void matchSetPaymentState(Map<String, BankResponse> infoMap, List<PaymentInfo> paymentInfos) {
        for (int i = 0; i < paymentInfos.size(); ++i) {
            String key = PaymentInfoSysFiled.get((PaymentInfo)paymentInfos.get(i), (String)"comFlowNo");
            if (infoMap.containsKey(key)) {
                String state = infoMap.get(key).getResponseCode();
                String errorString = infoMap.get(key).getResponseMessage();
                if (BankResponseCodeUtils.isSuccessed(state)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.SUCCESS, (String)BankResponseCodeUtils.getResponseMsg(state), (String)state, (String)errorString);
                    continue;
                }
                if (BankResponseCodeUtils.isFailed(state)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.FAIL, (String)BankResponseCodeUtils.getResponseMsg(state), (String)state, (String)errorString);
                    continue;
                }
                if (BankResponseCodeUtils.isSubmit(state)) {
                    EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)state, (String)errorString);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)BankResponseCodeUtils.getResponseMsg(state), (String)state, (String)errorString);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)"", (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5e8f\u53f7\u4e0d\u5339\u914d\uff0c\u72b6\u6001\u672a\u77e5\u3002", (String)"AllocationQueryPayImpl_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
        }
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "100009";
    }

    public String getBizDesc() {
        return "";
    }
}

