/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.payment;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.zsb.opa.services.payment.QueryPayImpl;
import kd.ebg.aqap.banks.zsb.opa.services.token.TokenService;
import kd.ebg.aqap.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        try {
            SdkInit.init();
            List paymentInfos = request.getPaymentInfos();
            PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
            HashMap<String, Object> body = new HashMap<String, Object>(20);
            body.put("payAccNo", info.getAccNo());
            body.put("payAccName", info.getAccName());
            body.put("payBankName", "");
            body.put("payBankNo", "");
            body.put("payCurCode", "01");
            body.put("bankFlag", info.is2SameBank() ? "0" : "1");
            body.put("accType", info.is2Individual() ? "1" : "2");
            body.put("amt", info.getAmount().toString());
            body.put("payeeAccNo", info.getIncomeAccNo());
            body.put("payeeAccName", info.getIncomeAccName());
            body.put("payeeBankName", "");
            body.put("proxyPayAccNo", "");
            body.put("proxyPayaccName", "");
            body.put("payeeBankNo", info.is2SameBank() ? "" : info.getIncomeCnaps());
            body.put("payeeCurCode", "01");
            body.put("purpose", "");
            if (BankBusinessConfig.isAddKDFlagToPay()) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
                body.put("postscript", BizNoUtil.cont((String)info.getBankDetailSeqId(), (String)info.getExplanation()));
            } else {
                body.put("postscript", info.getExplanation());
            }
            body.put("payflag", "");
            String token = TokenService.getInstance().getToken();
            try {
                String rsp = SdkInit.send("yqwfw_autoPay", info.getBankDetailSeqId(), token, body);
                return this.parse(request, rsp);
            }
            catch (Throwable t) {
                EBContext.getContext().setThrowableAfterSend(t);
                return null;
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u6253\u5305\u94f6\u884c\u4ed8\u6b3e\u8bf7\u6c42\u62a5\u6587\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PayImpl_5", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equals(statusCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PayImpl_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (String)statusCode, (String)statusDesc);
            return new EBBankPayResponse(paymentInfos);
        }
        JSONObject jsonBody = root.getJSONObject("body");
        String status = jsonBody.getString("status");
        if ("1".equals(status) || "2".equals(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_1", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"PayImpl_2", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
        } else if ("3".equals(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayImpl_3", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PayImpl_4", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PayImpl_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PayImpl_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "yqwfw_autoPay";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

