/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.EBBizType;
import kd.ebg.aqap.banks.nbcb.dc.service.NBCBEBankDataHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.ResponseCheck;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        Element list;
        Element NBCBEBankData = new Element("NBCBEBankData");
        NBCBEBankDataHelper.add(NBCBEBankData, LoginAndOut.getLoginAndOut().loginSessionId4Query(), "srv004_batchAccountInfoQuery", EBBizType.CUR_BALANCE);
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)NBCBEBankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)Sequence.gen18Sequence());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        if (CollectionUtil.isNotEmpty((Collection)request.getBankAcntList())) {
            list = new Element("list");
            JDomUtils.addChild((Element)ReqParam, (String)"SHMU", (String)String.valueOf(request.getBankAcntList().size()));
            for (BankAcnt bankAcnt : request.getBankAcntList()) {
                Element row = new Element("row");
                JDomUtils.addChild((Element)row, (String)"ZHHA", (String)bankAcnt.getAccNo());
                JDomUtils.addChild((Element)list, (Element)row);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)"The list of bankAcnt is empty.");
        }
        JDomUtils.addChild((Element)ReqParam, (Element)list);
        String signData = "null";
        JDomUtils.addChild((Element)NBCBEBankData, (String)"signData", (String)signData);
        return DomHelper.doc2StringPlain(new Document(NBCBEBankData), RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element NBCBEBankData = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        ResponseCheck.checkResponse(NBCBEBankData, ResManager.loadKDString((String)"\u6279\u91cf\u4f59\u989d\u67e5\u8be2\u4e1a\u52a1", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        Element opRep = DomHelper.getChildElementNotNull(NBCBEBankData, "opRep");
        Element list = DomHelper.getChildElementNotNull(opRep, "list");
        List rows = list.getChildren("row");
        if (CollectionUtil.isEmpty((Collection)rows)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6570\u636e\u4e2d\u8282\u70b9<%s>\u4e3a\u7a7a", (String)"TodayBalanceImpl_11", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), "row"));
        }
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        Map<String, BankAcnt> bankAcntMap = this.getBankAcntSet(request.getBankAcntList());
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String ZHHA = DomHelper.getChildText(row, "ZHHA");
            if (StringUtils.isEmpty((String)ZHHA) || !bankAcntMap.containsKey(ZHHA)) continue;
            String YUER = DomHelper.getChildText(row, "YUER");
            String KYER = DomHelper.getChildText(row, "KYER");
            String BIZH = DomHelper.getChildText(row, "BIZH");
            BankAcnt acnt = bankAcntMap.get(ZHHA);
            if (acnt == null) continue;
            BalanceInfo balance = new BalanceInfo();
            balances.add(balance);
            this.setBankAcnt(balance, acnt);
            this.setBalanceDateTime(balance, LocalDateTime.now());
            this.setAvailableBalance(balance, KYER);
            this.setCurrentBalance(balance, YUER);
            if (StringUtils.isNotEmpty((String)BIZH)) {
                this.setBankCurrency(balance, BIZH);
                continue;
            }
            String msg = ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u6237\u5e01\u79cd\u5b57\u6bb5BIZH\u4e3a\u7a7a", (String)"TodayBalanceImpl_10", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]);
            balance.setError(msg);
        }
        return new EBBankBalanceResponse(balances);
    }

    private Map<String, BankAcnt> getBankAcntSet(List<BankAcnt> bankAcntList) {
        HashMap<String, BankAcnt> map = new HashMap<String, BankAcnt>(10);
        for (BankAcnt bankAcnt : bankAcntList) {
            map.putIfAbsent(bankAcnt.getAccNo(), bankAcnt);
        }
        return map;
    }

    private BigDecimal convert(String amt, String tips) throws EBServiceException {
        try {
            return BigDecimalHelper.add((String)"0.00", (String)amt);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8f6c\u6362%1$s\u51fa\u9519,\u5f85\u8f6c\u6362\u7684\u503c\u4e3a:%2$s", (String)"TodayBalanceImpl_9", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), tips, amt), (Throwable)e);
        }
    }

    public int limit() {
        return 10;
    }

    public String getDeveloper() {
        return "deng_xu";
    }

    public String getBizCode() {
        return "srv004_batchAccountInfoQuery";
    }

    public String getBizDesc() {
        return EBBizType.CUR_BALANCE.getBizName();
    }

    public void configFactory(ConnectionFactory factory) {
        NBCBEBankDataHelper.configConnection(factory);
    }
}

