/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.EBBizType;
import kd.ebg.aqap.banks.nbcb.dc.service.NBCBEBankDataHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.ResponseCheck;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.jdom2.Document;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    public static final int PageSize = 20;

    public String getDeveloper() {
        return "deng_xu";
    }

    public String getBizCode() {
        return "srv005_accountTradeInfoQuery";
    }

    public String getBizDesc() {
        return "srv005_accountTradeInfoQuery";
    }

    public String pack(BankDetailRequest request) {
        return this.packDetail(request);
    }

    public String packDetail(BankDetailRequest rqst) throws EBServiceException {
        Element NBCBEBankData = new Element("NBCBEBankData");
        NBCBEBankDataHelper.add(NBCBEBankData, LoginAndOut.getLoginAndOut().loginSessionId4Query(), "srv005_accountTradeInfoQuery", EBBizType.DETAIL);
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)NBCBEBankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)RequestContextUtils.getRequestContext().getBankRequestSeq());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        JDomUtils.addChild((Element)ReqParam, (String)"ZHHA", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"QSRQ", (String)rqst.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)ReqParam, (String)"ZZRQ", (String)rqst.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)ReqParam, (String)"ZXJE", (String)"0.00");
        JDomUtils.addChild((Element)ReqParam, (String)"ZDJE", (String)"9999999999.99");
        if ("0".equalsIgnoreCase(this.getCurrentPage())) {
            this.setCurrentPage(1);
        }
        JDomUtils.addChild((Element)ReqParam, (String)"XSYH", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)ReqParam, (String)"XSTS", (String)"20");
        String signData = "null";
        JDomUtils.addChild((Element)NBCBEBankData, (String)"signData", (String)signData);
        return DomHelper.doc2StringPlain(new Document(NBCBEBankData), RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        return new EBBankDetailResponse(this.detailParser(request, responseStr));
    }

    public List<DetailInfo> detailParser(BankDetailRequest rqs, String rspStr) throws EBServiceException {
        this.setLastPage(true);
        Element NBCBEBankData = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        ResponseCheck.checkResponse(NBCBEBankData, ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1", (String)"DetailImpl_0", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        Element opRep = DomHelper.getChildElementNotNull(NBCBEBankData, "opRep");
        Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
        String ZHHA = DomHelper.getChildTextNotNull(opResult, "ZHHA", ResManager.loadKDString((String)"\u8d26\u53f7", (String)"DetailImpl_1", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        String HUMI = DomHelper.getChildTextNotNull(opResult, "HUMI", ResManager.loadKDString((String)"\u6237\u540d", (String)"DetailImpl_2", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        String BIZH = DomHelper.getChildTextNotNull(opResult, "BIZH", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DetailImpl_3", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        String SHMU = DomHelper.getChildTextNotNull(opResult, "SHMU", ResManager.loadKDString((String)"\u672c\u6b21\u8fd4\u56de\u7b14\u6570", (String)"DetailImpl_4", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        int page = Integer.parseInt(this.getCurrentPage()) + 1;
        this.setCurrentPage(page);
        if (StringUtils.isNotEmpty((String)SHMU)) {
            if (Integer.parseInt(SHMU) <= 20 * (page - 1)) {
                this.setLastPage(true);
            } else {
                this.setLastPage(false);
            }
        } else {
            this.setLastPage(true);
        }
        if (!ZHHA.equals(rqs.getAcnt().getAccNo())) {
            EBServiceException ex = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7(%1$s)\u548c\u8bf7\u6c42\u8d26\u53f7(%2$s)\u4e0d\u7b26\u3002", (String)"DetailImpl_15", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), ZHHA, rqs.getAcnt().getAccNo()));
            logger.info("", (Object)ex);
            throw ex;
        }
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(1);
        Element elelist = DomHelper.getChildElementNotNull(opRep, "list");
        List rows = elelist.getChildren("row");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String JDBZ = DomHelper.getChildTextNotNull(row, "JDBZ", ResManager.loadKDString((String)"\u501f\u8d37\u6807\u5fd7", (String)"DetailImpl_8", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String JYJE = DomHelper.getChildTextNotNull(row, "JYJE", ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"DetailImpl_9", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String JYRQ = DomHelper.getChildTextNotNull(row, "JYRQ", ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"DetailImpl_10", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String DFZH = DomHelper.getChildTextNotNull(row, "DFZH", ResManager.loadKDString((String)"\u5bf9\u65b9\u8d26\u53f7", (String)"DetailImpl_11", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String DFHM = DomHelper.getChildTextNotNull(row, "DFHM", ResManager.loadKDString((String)"\u5bf9\u65b9\u6237\u540d", (String)"DetailImpl_12", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String YUER = DomHelper.getChildTextNotNull(row, "YUER", ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d", (String)"DetailImpl_13", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String BEZH = DomHelper.getChildTextNotNull(row, "BEZH", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"DetailImpl_14", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String DFWD = DomHelper.getChildText(row, "DFWD");
            String DZHD = row.getChildText("DZHD");
            String JYSJ = row.getChildText("JYSJ");
            if (StringUtils.isEmpty((String)JYSJ)) {
                JYSJ = "00:00:00";
            }
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(rqs.getAcnt().getAccNo());
            detail.setAccName(rqs.getAcnt().getAccName());
            detail.setOppAccNo(DFZH);
            detail.setOppAccName(DFHM);
            detail.setOppBankName(DFWD);
            detail.setCurrency(BIZH);
            if ("D".equalsIgnoreCase(JDBZ)) {
                detail.setCreditAmount(new BigDecimal("0.00"));
                detail.setDebitAmount(BigDecimalHelper.add((String)"0.00", (String)JYJE));
            } else if ("C".equalsIgnoreCase(JDBZ)) {
                detail.setCreditAmount(BigDecimalHelper.add((String)"0.00", (String)JYJE));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else {
                EBServiceException ex = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7:%1$s\u3002", (String)"DetailImpl_16", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), JDBZ));
                logger.info("", (Object)ex);
                throw ex;
            }
            if (StringUtils.isNotEmpty((String)YUER)) {
                detail.setBalance(BigDecimalHelper.add((String)"0.00", (String)YUER));
            }
            String PATI = DomHelper.getChildTextNullAsBlank(row, "PATI");
            boolean isResolved = this.isResolved(PATI);
            LocalDateTime transTime = LocalDateTime.parse(JYRQ + JYSJ, DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss"));
            detail.setTransDate(transTime.toLocalDate());
            detail.setTransTime(transTime);
            detail.setExplanation(BEZH);
            if (isResolved && !StringUtils.isEmpty((String)BEZH) && BEZH.indexOf("_KD@") != -1) {
                int idx = BEZH.indexOf("_KD@");
                String bankDetailSeqId = BEZH.substring(idx);
                bankDetailSeqId = bankDetailSeqId.substring("_KD@".length());
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                detail.setKdFlag(bankDetailSeqId);
                detail.setPayBankDetailSeqID(bankDetailSeqId);
                detail.setExplanation(BEZH.substring(0, idx));
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(DZHD);
            String transDate = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(rqs.getAcnt().getAccNo(), transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            totalList.add(detail);
        }
        return totalList;
    }

    public boolean isSupportPage() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        NBCBEBankDataHelper.configConnection(factory);
    }

    public boolean isResolved(String val) {
        if (StringUtils.isEmpty((String)val)) {
            return true;
        }
        String DRCX = PropertiesConstants.getValue((String)"DRCX");
        String TH = PropertiesConstants.getValue((String)"TH");
        if (StringUtils.isEmpty((String)DRCX)) {
            DRCX = ResManager.loadKDString((String)"\u5f53\u65e5\u51b2\u9500", (String)"", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)TH)) {
            TH = ResManager.loadKDString((String)"\u9000\u6c47", (String)"", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]);
        }
        return !val.equalsIgnoreCase(DRCX) && !val.equalsIgnoreCase(TH);
    }
}

