/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.payment.individual;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.EBBizType;
import kd.ebg.aqap.banks.nbcb.dc.service.NBCBEBankDataHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.banks.nbcb.dc.service.sign.SignService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class PayPacker {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);

    public static String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        Object amount;
        PaymentInfo paymentInfo = paymentInfos.get(0);
        Element NBCBEBankData = new Element("NBCBEBankData");
        NBCBEBankDataHelper.add(NBCBEBankData, LoginAndOut.getLoginAndOut().loginSessionId4Pay(), "srv011_wageAgencyDeal", EBBizType.PAY_INDIV_REFUND);
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)NBCBEBankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        JDomUtils.addChild((Element)ReqParam, (String)"payAccount", (String)paymentInfo.getAccNo());
        BigDecimal sumAmount = new BigDecimal("0");
        for (PaymentInfo pi : paymentInfos) {
            amount = pi.getAmount();
            sumAmount = sumAmount.add((BigDecimal)amount);
        }
        JDomUtils.addChild((Element)ReqParam, (String)"totalAmt", (String)BigDecimalHelper.plain2((BigDecimal)sumAmount));
        JDomUtils.addChild((Element)ReqParam, (String)"totalNumber", (String)(paymentInfos.size() + ""));
        Element list = new Element("list");
        JDomUtils.addChild((Element)ReqParam, (Element)list);
        StringBuilder signString = new StringBuilder();
        signString.append(paymentInfo.getAccNo());
        signString.append("-");
        signString.append(BigDecimalHelper.plain2((BigDecimal)sumAmount));
        signString.append("|");
        amount = paymentInfos.iterator();
        while (amount.hasNext()) {
            PaymentInfo pi;
            PaymentInfo Info = pi = (PaymentInfo)amount.next();
            Element row = new Element("row");
            JDomUtils.addChild((Element)list, (Element)row);
            JDomUtils.addChild((Element)row, (String)"payeeNo", (String)"1");
            JDomUtils.addChild((Element)row, (String)"userName", (String)Info.getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"recAccount", (String)Info.getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"transferSum", (String)BigDecimalHelper.plain2((BigDecimal)Info.getAmount()));
            String remark = Info.getExplanation();
            JDomUtils.addChild((Element)row, (String)"remark", (String)(null == remark ? "" : remark));
            signString.append(Info.getIncomeAccNo());
            signString.append("-");
            signString.append(Info.getIncomeAccName());
            signString.append("-");
            signString.append(BigDecimalHelper.plain2((BigDecimal)Info.getAmount()));
            signString.append("|");
        }
        String signData = SignService.sign(signString.toString());
        JDomUtils.addChild((Element)NBCBEBankData, (String)"signData", (String)signData);
        String encoding = RequestContextUtils.getCharset();
        return DomHelper.doc2StringPlain(new Document(NBCBEBankData), encoding);
    }
}

