/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.payment.individual;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public static EBBankPayResponse parseQueryPay(BankPayRequest request, String rspStr) {
        List<PaymentInfo> paymentInfos = request.getPaymentInfos();
        Element NBCBEBankData = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        String retCode = JDomUtils.getChildText((Element)NBCBEBankData, (String)"retCode");
        String errorMsg = JDomUtils.getChildText((Element)NBCBEBankData, (String)"errorMsg");
        if (!retCode.equals("0000") && !retCode.equalsIgnoreCase("000000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)errorMsg);
        } else {
            try {
                Element opRep = DomHelper.getChildElementNotNull(NBCBEBankData, "opRep");
                Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
                Element list = DomHelper.getChildElementNotNull(opResult, "list");
                List rows = list.getChildren("row");
                paymentInfos = QueryPayParser.preBatchSameItemCheck(request);
                for (Element row : rows) {
                    String recAccount = DomHelper.getChildTextNotNull(row, "recAccount");
                    String transferSum = DomHelper.getChildTextNotNull(row, "transferSum");
                    String orderState = DomHelper.getChildTextNotNull(row, "orderState");
                    PaymentInfo payment = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)recAccount, (BigDecimal)new BigDecimal(transferSum));
                    if (payment == null) {
                        logger.info("\u67e5\u8be2\u4e0d\u5230\u8be5\u4ed8\u6b3e\u6570\u636e\uff1a" + recAccount + "----" + transferSum);
                        continue;
                    }
                    QueryPayParser.handlePayStatus(payment, orderState);
                }
                QueryPayParser.processingBankItemDataHandler(rows);
                PayStatusMatchUtil.backBatchSameItemHandler((List)request.getPaymentInfos(), (boolean)false, (boolean)false);
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6\u8282\u70b9\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private static List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    private static void processingBankItemDataHandler(List<Element> elementList) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = QueryPayParser.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String orderState = JDomUtils.getChildText((Element)element, (String)"orderState");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    QueryPayParser.handlePayStatus(tempInfo, orderState);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public static PaymentInfo handlePayStatus(PaymentInfo tempInfo, String orderState) {
        if ("1".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)orderState, (String)"");
        } else if ("2".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)orderState, (String)"");
        } else if ("0".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)orderState, (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)orderState, (String)"");
        }
        return tempInfo;
    }

    private static String getBankDataKey(Element element) {
        String incomeNo = element.getChildText("recAccount");
        String incomeName = element.getChildText("userName");
        String amount = element.getChildText("transferSum");
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(incomeNo).append(incomeName).append(new BigDecimal(amount).setScale(2).toString());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getAmountErrorFormatTips(), (Throwable)e);
        }
        return buffer.toString();
    }
}

