/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.itbjfcl.dc.services.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.banks.itbjfcl.dc.services.util.Helper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/FrontEnd/FrontEndServlet");
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = JDomUtils.createRoot((String)"Iss_Itreasury");
        Element queryReq = JDomUtils.addChild((Element)root, (String)"QueryReq");
        boolean innerAcnt = Helper.isInnerAcnt(bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)queryReq, (String)"OperationType", (String)(innerAcnt ? "5" : "7"));
        JDomUtils.addChild((Element)queryReq, (String)"SystemID", (String)"ERP");
        JDomUtils.addChild((Element)queryReq, (String)"SendTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS")));
        Element queryContent = JDomUtils.addChild((Element)queryReq, (String)"QueryContent");
        JDomUtils.addChild((Element)queryContent, (String)"AccountNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)queryContent, (String)"QueryDateStart", (String)bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)queryContent, (String)"QueryDateEnd", (String)bankBalanceRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE1", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE2", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE3", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE4", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE5", (String)"");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element queryRen = JDomUtils.getChildElement((Element)root, (String)"QueryRen");
        String processCode = JDomUtils.getChildText((Element)queryRen, (String)"ProcessCode");
        String processDesc = JDomUtils.getChildText((Element)queryRen, (String)"ProcessDesc");
        if (!"0000".equalsIgnoreCase(processCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)processCode, (String)processDesc));
        }
        List elements = queryRen.getChildren("RenContent");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        for (Element renContent : elements) {
            BalanceInfo balanceInfo = new BalanceInfo();
            String accountNo = JDomUtils.getChildText((Element)renContent, (String)"AccountNo");
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), accountNo);
            balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
            String balance = JDomUtils.getChildText((Element)renContent, (String)"Balance").replaceAll(",", "");
            this.setCurrentBalance(balanceInfo, balance);
            this.setAvailableBalance(balanceInfo, balance);
            try {
                String balanceDate = JDomUtils.getChildText((Element)renContent, (String)"BalanceDate");
                balanceInfo.setBalanceDateTime(LocalDate.parse(balanceDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")).atStartOfDay());
            }
            catch (Exception e) {
                balanceInfo.setError(BalanceUtils.wrongDateFormatter());
            }
            balances.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balances);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public int queryDays() {
        return 31;
    }
}

