/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jsb.cmp.service.balance;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jsb.cmp.service.BankBusinessConfig;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Packer;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GJTodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final Logger logger = LoggerFactory.getLogger(GJTodayBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead("00003040204A3002", Sequence.gen14Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"Start", (String)"1");
        JDomUtils.addChild((Element)body, (String)"Size", (String)"1");
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        logger.info("\u5f52\u96c6\u6237\u4f59\u989d\u67e5\u8be2\u54cd\u5e94\u62a5\u6587" + responseStr);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u96c6\u6237\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"GJTodayBalanceImpl_3", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element body = root.getChild("body");
        List dtoList = body.getChild("array").getChildren("dto");
        Element element = (Element)dtoList.get(0);
        String upDepositBal = element.getChildTextTrim("upDepositBal");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(request.getAcnt());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        if (StringUtils.isEmpty((String)upDepositBal)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d\u8fd4\u56de\u4e3a\u7a7a", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]));
        }
        balanceInfo.setAvailableBalance(new BigDecimal(upDepositBal));
        balanceInfo.setCurrentBalance(new BigDecimal(upDepositBal));
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo());
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }

    public String getBizCode() {
        return "00003040204A3002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f52\u96c6\u6237\u4f59\u989d\u67e5\u8be2", (String)"GJTodayBalanceImpl_2", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]);
    }
}

