/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbb.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbb.dc.util.HeadPacker;
import kd.ebg.aqap.banks.hbb.dc.util.HeadParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public static final String TRANCODE = "eb2e-acmgmt.AccountBalanceQuery";

    public String pack(BankBalanceRequest rqst) {
        String accNo = rqst.getAcnt().getAccNo();
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)HeadPacker.buildHead(TRANCODE, Sequence.gen18Sequence()));
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"acNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"subAcNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"reqReserved1", (String)"");
        JDomUtils.addChild((Element)body, (String)"reqReserved2", (String)"");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)ebank_root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());
        EBBankBalanceResponse balanceRsp = new EBBankBalanceResponse();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = HeadParser.parserCommonInfo(root);
        if (!"00000000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            logger.error(resMsg);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"Body");
        boolean flag = false;
        BalanceInfo balanceInfo = new BalanceInfo();
        String accNo = JDomUtils.getChildText((Element)resBody, (String)"acNo");
        String currency = JDomUtils.getChildText((Element)resBody, (String)"currencyCode");
        String balance = resBody.getChildText("balance");
        String availBal = resBody.getChildText("availBal");
        this.setBankCurrency(balanceInfo, currency);
        this.setBankAcnt(balanceInfo, rqst.getBankAcntList(), accNo);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, balance);
        this.setAvailableBalance(balanceInfo, availBal);
        ArrayList<BalanceInfo> list = new ArrayList<BalanceInfo>(1);
        list.add(balanceInfo);
        balanceRsp.setBalances(list);
        return balanceRsp;
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/eb2e-acmgmt.AccountBalanceQuery.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=1";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String getDeveloper() {
        return "simin_wx";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]);
    }
}

