/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbb.dc.service.payment.single;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hbb.dc.service.payment.single.QueryPayImpl;
import kd.ebg.aqap.banks.hbb.dc.util.HeadPacker;
import kd.ebg.aqap.banks.hbb.dc.util.HeadParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl {
    private static final String TRANCODE = "eb2e-transfer.Transfer";

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/eb2e-transfer.Transfer.do?";
        s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userPassword") + "&SIGDATA=1&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String getDeveloper() {
        return "simon_wx";
    }

    public void closeOutputStreamQuietly(OutputStream outputStream) {
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u7b14\u4ed8\u6b3e", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]));
        }
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)HeadPacker.buildHead(TRANCODE, paymentInfos[0].getBankBatchSeqId()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"payerAcNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"payerAcName", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)body, (String)"payerSubAcNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"payeeAcNo", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"payeeSubAcNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"payeeAcName", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"amount", (String)paymentInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"currencyCode", (String)paymentInfos[0].getCurrency());
        if (!paymentInfos[0].is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"payeeBankDeptId", (String)paymentInfos[0].getIncomeCnaps());
            JDomUtils.addChild((Element)body, (String)"payeeBankDeptName", (String)paymentInfos[0].getIncomeBankName());
        }
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfos[0].getExplanation());
        String transferUsage = paymentInfos[0].getExplanation();
        if (StringUtils.isEmpty((String)transferUsage)) {
            transferUsage = ResManager.loadKDString((String)"\u94f6\u4f01\u4ed8\u6b3e", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]);
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
            transferUsage = transferUsage + "KD@" + paymentInfos[0].getBankDetailSeqId();
        }
        JDomUtils.addChild((Element)body, (String)"transferUsage", (String)transferUsage);
        BigDecimal amount = paymentInfos[0].getAmount().setScale(2, 4);
        String remitModel = "1";
        JDomUtils.addChild((Element)body, (String)"trsType", (String)(paymentInfos[0].is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"remitModel", (String)remitModel);
        JDomUtils.addChild((Element)body, (String)"payeePhoneNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"notifyPayee", (String)"0");
        String bankcode = "";
        String bankName = "";
        if (!paymentInfos[0].is2SameBank()) {
            String cnaps = paymentInfos[0].getIncomeCnaps();
            if (StringUtils.isEmpty((String)cnaps)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8de8\u884c\u652f\u4ed8\u8054\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]));
            }
            bankcode = cnaps.substring(0, 3);
            bankName = paymentInfos[0].getIncomeBankName();
        }
        JDomUtils.addChild((Element)body, (String)"payeeBankCode", (String)bankcode);
        JDomUtils.addChild((Element)body, (String)"payeeBankName", (String)bankName);
        String requestXml = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return requestXml;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        String returnCode;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = HeadParser.parserCommonInfo(root);
        if (!"00000000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element resHead = JDomUtils.getChildElement((Element)root, (String)"Head");
        String string = returnCode = StringUtils.isEmpty((String)JDomUtils.getChildText((Element)resBody, (String)"processState")) ? JDomUtils.getChildTextTrim((Element)resHead, (String)"_ProcessState") : JDomUtils.getChildText((Element)resBody, (String)"processState");
        if ("OK".equalsIgnoreCase(returnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PaymentImpl_8", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else if ("FL".equalsIgnoreCase(returnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_9", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getBizCode() {
        return "Transfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26\uff08eb2e-transfer.Transfer\uff09\u3002", (String)"PaymentImpl_10", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

