/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.service.payment.company;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Packer;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Parser;
import kd.ebg.aqap.banks.hsbc.dc.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.hsbc.dc.utils.HSBC_DC_Utils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return BankBusinessConfig.getBatchNumber();
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element simulator = new Element("simulator");
        Element head = HSBC_DC_Packer.createHead("BATCH_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileType", (String)"string");
        if (BankBusinessConfig.isWebservice()) {
            JDomUtils.addChild((Element)reqPara, (String)"uploadMethod", (String)"ws");
        } else {
            JDomUtils.addChild((Element)reqPara, (String)"uploadMethod", (String)"ftp");
        }
        JDomUtils.addChild((Element)reqPara, (String)"connectCustomerID", (String)RequestContextUtils.getBankParameterValue((String)"CONNECT_CUSTOMER_ID"));
        JDomUtils.addChild((Element)reqPara, (String)"netCustomerID", (String)RequestContextUtils.getBankParameterValue((String)"NET_CUSTOMER_ID"));
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)reqPara, (String)"batchSequence", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
            JDomUtils.addChild((Element)list, (String)"acntNo", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)list, (String)"acntName", (String)((PaymentInfo)paymentInfos.get(i)).getAccName());
            JDomUtils.addChild((Element)list, (String)"acntType", (String)"");
            JDomUtils.addChild((Element)list, (String)"acntBankName", (String)((PaymentInfo)paymentInfos.get(i)).getBankName());
            JDomUtils.addChild((Element)list, (String)"acntCountry", (String)("001".equalsIgnoreCase(((PaymentInfo)paymentInfos.get(i)).getAccCountry()) ? ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]) : ((PaymentInfo)paymentInfos.get(i)).getAccCountry()));
            JDomUtils.addChild((Element)list, (String)"acntProvince", (String)((PaymentInfo)paymentInfos.get(i)).getAccProvince());
            JDomUtils.addChild((Element)list, (String)"acntCity", (String)((PaymentInfo)paymentInfos.get(i)).getAccCity());
            JDomUtils.addChild((Element)list, (String)"acntBankBranchNo", (String)((PaymentInfo)paymentInfos.get(i)).getAreaCode());
            JDomUtils.addChild((Element)list, (String)"acntBankCnapsNo", (String)"");
            JDomUtils.addChild((Element)list, (String)"currency", (String)((PaymentInfo)paymentInfos.get(i)).getCurrency());
            LocalDateTime now = LocalDateTime.now();
            JDomUtils.addChild((Element)list, (String)"startDate", (String)now.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)list, (String)"startTime", (String)now.format(DateTimeFormatter.ofPattern("HHmmss")));
            JDomUtils.addChild((Element)list, (String)"serialNo", (String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId());
            JDomUtils.addChild((Element)list, (String)"txAmt", (String)BigDecimalHelper.plain2((BigDecimal)((PaymentInfo)paymentInfos.get(i)).getAmount()));
            JDomUtils.addChild((Element)list, (String)"urgentFlag", (String)(((PaymentInfo)paymentInfos.get(i)).is2Urgent() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameBankFlag", (String)(((PaymentInfo)paymentInfos.get(i)).is2SameBank() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameCityFlag", (String)(((PaymentInfo)paymentInfos.get(i)).is2SameCity() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"payType", (String)(((PaymentInfo)paymentInfos.get(i)).is2Individual() ? "individual" : "company"));
            JDomUtils.addChild((Element)list, (String)"email", (String)((PaymentInfo)paymentInfos.get(i)).getEmails());
            JDomUtils.addChild((Element)list, (String)"oppAcntNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)list, (String)"oppAcntName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)list, (String)"oppAcntNameEN", (String)"");
            JDomUtils.addChild((Element)list, (String)"oppBankName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)list, (String)"oppAcntCountry", (String)("CHN".equalsIgnoreCase(((PaymentInfo)paymentInfos.get(i)).getIncomeCountry()) ? ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]) : ((PaymentInfo)paymentInfos.get(i)).getIncomeCountry()));
            JDomUtils.addChild((Element)list, (String)"oppAcntProvince", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeProvince());
            JDomUtils.addChild((Element)list, (String)"oppAcntCity", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCity());
            JDomUtils.addChild((Element)list, (String)"oppBankBranchNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAreaCode());
            JDomUtils.addChild((Element)list, (String)"oppBankCnapsNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps());
            JDomUtils.addChild((Element)list, (String)"oppBankSwiftCode", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeSwiftCode());
            JDomUtils.addChild((Element)list, (String)"useCode", (String)"");
            String explanation = ((PaymentInfo)paymentInfos.get(i)).getExplanation();
            JDomUtils.addChild((Element)list, (String)"explanation", (String)HSBC_DC_Utils.replaceInvalidChar(explanation));
        }
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = HSBC_DC_Parser.parseHeader(root);
        if ("BIZ_FAIL".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() < 1) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u5217\u8868\u4e3a\u7a7a\u3002", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String sequence = JDomUtils.getChildTextTrim((Element)list, (String)"sequence");
            String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
            Element status = JDomUtils.getChildElement((Element)list, (String)"status");
            String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
            String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)sequence);
            if (null == info) continue;
            if ("BCC_PAY_SUBMT_SUCCESS".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyPayImpl_3", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

