/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.service.payment.oversea;

import java.io.File;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Packer;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverSeaQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    Logger logger = LoggerFactory.getLogger(OverSeaQueryPayImpl.class);

    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 0;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element simulator = new Element("simulator");
        Element head = HSBC_DC_Packer.createHead("QUERY_BATCH_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)reqPara, (String)"batchSequence", (String)paymentInfos[0].getBankBatchSeqId());
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
            JDomUtils.addChild((Element)list, (String)"serialNo", (String)paymentInfos[i].getBankDetailSeqId());
        }
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return HSBC_DC_Parser.parseQueryPayResponse(request, responseStr);
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        EBContext ebContext = EBContext.getContext();
        String ip = ebContext.getParameter().getBankParameter("SFTP_IP");
        String port = ebContext.getParameter().getBankParameter("SFTP_PORT");
        String userName = ebContext.getParameter().getBankParameter("SFTP_USERNAME");
        String userPassword = ebContext.getParameter().getBankParameter("SFTP_PASSWORD");
        String ackPath = ebContext.getParameter().getBankParameter("SFTP_ACK_PATH");
        String localAckPath = ebContext.getParameter().getBankParameter("LOCAL_ACK_PATH");
        String localTransationAckPath = ebContext.getParameter().getBankParameter("LOCAL_TRANSATION_ACK_PATH");
        String ackTemp = localAckPath + File.separator + "temp";
        String transcationAckTemp = localTransationAckPath + File.separator + "temp";
        EBBankPayResponse bankPayResponse = this.parse(request, ackTemp + "|" + transcationAckTemp);
        return bankPayResponse;
    }
}

