/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.amh;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    public static final PropertyConfigItem CITIC_AMH_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("CITIC_AMH_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4\u3002", "BankBusinessConfig_81", "ebg-aqap-banks-citic-amh")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002", "BankBusinessConfig_82", "ebg-aqap-banks-citic-amh"), new MultiLangEnumBridge("\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_83", "ebg-aqap-banks-citic-amh")})).set2Integer().set2MinValueNum(Integer.valueOf(0)).defaultValues((List)Lists.newArrayList((Object[])new String[]{"0"})).build();

    public String getBankVersionID() {
        return "CITIC_AMH";
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List configItemList = this.getBankAddtionalPropertyConfigItems(false, false, false, false);
        configItemList.addAll(Lists.newArrayList((Object[])new PropertyConfigItem[]{CITIC_AMH_PAY_STATE_TIMEOUT, BANK_SWIFT_CODE}));
        return configItemList;
    }

    public static int getPayStateTimeout() {
        String config = CITIC_AMH_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != config && config.length() > 0) {
            try {
                if (Integer.parseInt(config) > 0) {
                    timeout = Integer.parseInt(config);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static boolean isPayStateTimeout(LocalDateTime submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        LocalDateTime time = submitSuccessTime.plus(payStateTimeout * 60 * 60, ChronoUnit.SECONDS);
        return time.isBefore(LocalDateTime.now());
    }

    public static String getBicCode(String accNo) {
        return BANK_SWIFT_CODE.getCurrentValueWithObjectID(accNo);
    }
}

