/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.amh.services.payment.oversea;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.amh.BankBusinessConfig;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLXPYAQY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d77\u5916\u8d44\u91d1\u8f6c\u8d26\u8bf7\u6c42\u72b6\u6001\u67e5\u8be2", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        LocalDateTime search;
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String pay_submit = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"pay_submit");
        String bankRefId = paymentInfo.getBankRefID();
        if (StringUtils.isEmpty((String)bankRefId)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"BankRefID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\u4ea4\u6613\u7ed3\u679c", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)pay_submit)) {
            Element root = JDomUtils.createRoot((String)"stream");
            JDomUtils.addChild((Element)root, (String)"action", (String)"DLXPYAQY");
            JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
            String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String prex = RequestContextUtils.getBankParameterValue((String)"userprex");
            StringBuilder builder = new StringBuilder();
            builder.append(prex).append(date).append(Sequence.getAutoincrementNumber((int)7));
            JDomUtils.addChild((Element)root, (String)"clientID", (String)builder.toString());
            JDomUtils.addChild((Element)root, (String)"tranNo", (String)builder.toString());
            JDomUtils.addChild((Element)root, (String)"version", (String)"1.0.0");
            JDomUtils.addChild((Element)root, (String)"channelFlag", (String)prex);
            String qryTranNo = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"pay_tranNo");
            if (StringUtils.isEmpty((String)qryTranNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"qryTranNo\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\u4ea4\u6613\u7ed3\u679c", (String)"CompanyQueryPayImpl_7", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)root, (String)"qryTranNo", (String)qryTranNo);
            JDomUtils.addChild((Element)root, (String)"qryEbkNo", (String)bankRefId);
            JDomUtils.addChild((Element)root, (String)"qryMessType", (String)"MT101");
            String encoding = RequestContextUtils.getCharset();
            String message = JDomUtils.root2String((Element)root, (String)encoding);
            return message;
        }
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLMTCQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"accNo", (String)request.getHeader().getAcnt().getAccNo());
        LocalDateTime localDateTime = search = paymentInfo.getSubmitSuccessTime() == null ? paymentInfo.getInsertTime() : paymentInfo.getSubmitSuccessTime();
        if (search == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u67e5\u8be2\u65e5\u671f\u4e3anull", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]));
        }
        String startDate = search.toLocalDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDate = "";
        LocalDate now = LocalDate.now();
        long dayOff = ChronoUnit.DAYS.between(search.toLocalDate(), now);
        endDate = dayOff > 6L ? search.toLocalDate().plusDays(6L).format(DateTimeFormatter.ofPattern("yyyyMMdd")) : now.plusDays(-1L).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)root, (String)"startDate", (String)startDate);
        JDomUtils.addChild((Element)root, (String)"endDate", (String)endDate);
        JDomUtils.addChild((Element)root, (String)"pageNumber", (String)"10");
        JDomUtils.addChild((Element)root, (String)"startRecord", (String)"1");
        if (dayOff == 0L) {
            JDomUtils.addChild((Element)root, (String)"msgType", (String)"AMH942");
        } else {
            JDomUtils.addChild((Element)root, (String)"msgType", (String)"AMH940");
        }
        JDomUtils.addChild((Element)root, (String)"refNum", (String)bankRefId);
        JDomUtils.addChild((Element)root, (String)"foreignDCFlag", (String)"D");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        String status = root.getChildText("status");
        String statusText = root.getChildText("statusText");
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String pay_submit = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"pay_submit");
        if (StringUtils.isEmpty((String)pay_submit)) {
            if ("AAAAAAA".equalsIgnoreCase(status)) {
                String stt = root.getChildText("stt");
                String sttDesc = root.getChildText("sttDesc");
                if ("F".equalsIgnoreCase(stt)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)stt, (String)sttDesc);
                } else if ("S".equalsIgnoreCase(stt)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)statusText);
                } else if ("P".equalsIgnoreCase(stt)) {
                    PaymentInfoSysFiled.set((List)paymentInfos, (String)"pay_submit", (String)"true");
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)statusText);
                }
            }
        } else {
            int totalRecords = Integer.parseInt(root.getChildText("totalNum"));
            if (totalRecords >= 1) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)status, (String)statusText);
            } else {
                LocalDateTime search;
                LocalDateTime localDateTime = search = paymentInfo.getSubmitSuccessTime() == null ? paymentInfo.getInsertTime() : paymentInfo.getSubmitSuccessTime();
                if (search == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u67e5\u8be2\u65e5\u671f\u4e3anull", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]));
                }
                if (BankBusinessConfig.isPayStateTimeout(search)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]), (String)status, (String)statusText);
                }
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

