/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.opa.services.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.opa.utils.CMBCBankResponse;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcPacker;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcParser;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcRequest;
import kd.ebg.aqap.banks.cmbc.opa.utils.OpenIDUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger LOGGER = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        List bankAcntList = request.getBankAcntList();
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList balanceInfos = new ArrayList();
        for (BankAcnt bankAcnt : bankAcntList) {
            try {
                request.getHeader().setAcnt(bankAcnt);
                EBBankBalanceResponse response = this.doBiz(request);
                balanceInfos.addAll(response.getBalances());
            }
            catch (EBServiceException e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4eca\u65e5\u4f59\u989d\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1a%s", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]), e.getCause()));
            }
        }
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    public String pack(BankBalanceRequest request) {
        CmbcRequest cmbcRequest = new CmbcRequest("account.transinfo.balance_query");
        HashMap<String, Object> busiParamMap = new HashMap<String, Object>();
        busiParamMap.put("acct_no", request.getAcnt().getAccNo());
        busiParamMap.put("date_from", request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        busiParamMap.put("service_group", BankBusinessConfig.getCmbcServiceGroup());
        busiParamMap.put("open_id", OpenIDUtil.getOpenId(request.getAcnt().getAccNo()));
        cmbcRequest.setBusiParamMap(busiParamMap);
        return CmbcPacker.prepareParams(cmbcRequest);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Map responseMap = (Map)JSON.parseObject((String)responseStr, Map.class);
        CMBCBankResponse bankResponse = CmbcParser.getBankResponse(responseMap);
        if ("false".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)bankResponse.getResponseMessage());
        }
        JSONObject busiJson = JSON.parseObject((String)bankResponse.getResponseBusi());
        BankAcnt bankAcnt = request.getAcnt();
        String accountNo = busiJson.getString("acct_no");
        if (!bankAcnt.getAccNo().equals(accountNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7[%1$s]\u4e0e\u8fd4\u56de\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]), bankAcnt.getAccNo(), accountNo));
        }
        ArrayList<BalanceInfo> balanceList = new ArrayList<BalanceInfo>();
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(bankAcnt);
        balanceInfo.setCurrentBalance(busiJson.getBigDecimal("balance"));
        balanceInfo.setAvailableBalance(busiJson.getBigDecimal("avl_bal"));
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceList.add(balanceInfo);
        return new EBBankBalanceResponse(balanceList);
    }

    public String getDeveloper() {
        return "kylin";
    }

    public String getBizCode() {
        return "query_balance";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]);
    }
}

