/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.opa.utils;

import com.cmbc.openbank.api.utils.SignVerifyTenantUtil;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.opa.utils.CMBCBankResponse;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.utils.CMBCCertificateUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class CmbcParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CmbcParser.class);
    private static final String RETURN_CODE = "return_code";
    private static final String RETURN_MESSAGE = "return_msg";
    private static final String RETURN_BUSINESS = "response_busi";
    private static final String RETURN_SIGN = "sign";
    private static final String FALSE_VALUE = "false";

    private CmbcParser() {
    }

    public static CMBCBankResponse getBankResponse(Map<String, Object> responseMap) {
        CMBCBankResponse bankResponse = new CMBCBankResponse();
        if (!responseMap.containsKey(RETURN_CODE)) {
            bankResponse.setResponseCode(FALSE_VALUE);
            bankResponse.setResponseMessage(ResManager.loadKDString((String)"\u62a5\u6587\u8fd4\u56de\u5f02\u5e38\uff0c\u6ca1\u6709return_code", (String)"CmbcParser_0", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]));
            return bankResponse;
        }
        String code = (String)responseMap.getOrDefault(RETURN_CODE, "");
        String msg = (String)responseMap.getOrDefault(RETURN_MESSAGE, "");
        if (!"0000".equals(code)) {
            bankResponse.setResponseCode(FALSE_VALUE);
            bankResponse.setResponseMessage(String.format("%s[%s]", msg, code));
        } else if (!responseMap.containsKey(RETURN_BUSINESS)) {
            bankResponse.setResponseCode(FALSE_VALUE);
            bankResponse.setResponseMessage(ResManager.loadKDString((String)"\u62a5\u6587\u8fd4\u56de\u5f02\u5e38\uff0c\u6ca1\u6709response_busi", (String)"CmbcParser_1", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]));
        } else if (!responseMap.containsKey(RETURN_SIGN)) {
            bankResponse.setResponseCode(FALSE_VALUE);
            bankResponse.setResponseMessage(ResManager.loadKDString((String)"\u62a5\u6587\u8fd4\u56de\u5f02\u5e38\uff0c\u6ca1\u6709sign", (String)"CmbcParser_2", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]));
        } else {
            String responseBusiStr = responseMap.get(RETURN_BUSINESS).toString();
            CertInfo privateCertInfo = CMBCCertificateUtil.getPrivateCertInfo();
            if (privateCertInfo == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u4e0a\u4f20\u4e86\u79c1\u94a5\u6587\u4ef6", (String)"CmbcParser_3", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]));
            }
            String privateKeyPwd = privateCertInfo.getCertPassword();
            String privateKey = CMBCCertificateUtil.getPrivateFileDir((CertInfo)privateCertInfo);
            String cmbcPublicKey = CMBCCertificateUtil.getPublicFileDir();
            responseBusiStr = SignVerifyTenantUtil.openEnvelopedMessageA((String)privateKey, (String)privateKeyPwd, (String)cmbcPublicKey, (String)responseBusiStr);
            logger.info("\u6c11\u751f\u94f6\u884c\u8fd4\u56de\u7684\u4e1a\u52a1\u54cd\u5e94\u6570\u636e\uff1a" + responseBusiStr);
            bankResponse.setResponseBusi(responseBusiStr);
            if (SignVerifyTenantUtil.verifyA((String)privateKey, (String)privateKeyPwd, (String)cmbcPublicKey, (String)((String)responseMap.get(RETURN_SIGN)), (String)responseBusiStr)) {
                bankResponse.setResponseCode("true");
                bankResponse.setResponseMessage(msg);
            } else {
                bankResponse.setResponseCode(FALSE_VALUE);
                bankResponse.setResponseMessage(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25", (String)"CmbcParser_4", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]));
            }
        }
        return bankResponse;
    }
}

