/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.opa.utils;

import kd.ebg.aqap.banks.cmbc.opa.BankBusinessConfig;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OpenIDUtil {
    private OpenIDUtil() {
    }

    public static void updateOpenID(String customID, String openId, String accNo) {
        BankAcntRepository bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);
        BankAcnt bankAcnt = bankAcntRepository.findByAccNoAndCustomID(accNo, customID);
        if (bankAcnt != null) {
            BankLoginConfigService service = (BankLoginConfigService)SpringContextUtil.getBean(BankLoginConfigService.class);
            service.saveBankLoginConfig("CMBC_OPEN_ID", openId, bankAcnt.getBankLoginId(), customID);
        }
        ObjectPropertyService objectPropertyService = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
        objectPropertyService.saveAcntProperties("CMBC_ACCNO_OPEN_ID", openId, accNo);
    }

    public static String getOpenId(String AccNo) {
        String openId = BankBusinessConfig.getAccNoOpenId(AccNo);
        if (StringUtils.isNotEmpty((String)openId)) {
            return openId;
        }
        return RequestContextUtils.getBankParameterValue((String)"CMBC_OPEN_ID");
    }
}

