/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.ParserUtil;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.codeless.PackerUtil.CodeLessUtil;
import kd.ebg.egf.common.codeless.PackerUtil.PackerCommon;
import kd.ebg.egf.common.codeless.PackerUtil.ResponseCode;
import kd.ebg.egf.common.codeless.ParserUtil.JSONParseUtil;
import kd.ebg.egf.common.codeless.ParserUtil.JsonToMapUtil;
import kd.ebg.egf.common.codeless.ParserUtil.XMLParseUtil;
import kd.ebg.egf.common.codeless.ParserUtil.XmlToMapUtil;
import kd.ebg.egf.common.codeless.services.FuncNameRelection;
import kd.ebg.egf.common.codeless.services.Function;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.codeless.CodeLessService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.codeless.CodeLess;
import kd.ebg.egf.common.model.codeless.CodeLessRespResultParam;
import kd.ebg.egf.common.model.codeless.CodeLessResponseBody;
import kd.ebg.egf.common.model.codeless.JudgingCondition1;
import kd.ebg.egf.common.model.codeless.JudgingConditionBody;
import kd.ebg.egf.common.model.codeless.JudgingConditionValue;
import kd.ebg.egf.common.model.codeless.JudgingConditions;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.dom4j.DocumentException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public class ParseUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ParseUtil.class);
    private static final String SPLIT = " ";

    public static String getResult(ResponseCode responseCode, String inner_code, String inner_code2, String app, String inner_code3) {
        CodeLessRespResultParam param = new CodeLessRespResultParam();
        CodeLess codeLess = EBContext.getContext().getCodeLess();
        param.setBankVersionID(codeLess.getBankVersionID());
        param.setInterfaceCode(codeLess.getInterfaceCode());
        if (responseCode != null) {
            param.setOutCodeValue(responseCode.getCode());
        }
        param.setInnerCodeValue(inner_code);
        param.setInnerCodeValue2(inner_code2);
        param.setInnerCodeValue3(inner_code3);
        return CodeLessService.getInstance().getResponseResult(param, app);
    }

    public static String getResult(ResponseCode responseCode, String inner_code, String inner_code2, String app) {
        CodeLessRespResultParam param = new CodeLessRespResultParam();
        CodeLess codeLess = EBContext.getContext().getCodeLess();
        param.setBankVersionID(codeLess.getBankVersionID());
        param.setInterfaceCode(codeLess.getInterfaceCode());
        if (responseCode != null) {
            param.setOutCodeValue(responseCode.getCode());
        }
        param.setInnerCodeValue(inner_code);
        param.setInnerCodeValue2(inner_code2);
        return CodeLessService.getInstance().getResponseResult(param, app);
    }

    public static boolean isBatchParser() {
        CodeLess codeLess = EBContext.getContext().getCodeLess();
        CodeLessResponseBody inner = null;
        List<CodeLessResponseBody> codeLessResponseBodies = codeLess.getResponseBodys();
        for (CodeLessResponseBody codeLessResponseBody : codeLessResponseBodies) {
            if (!"inner_code".equals(codeLessResponseBody.getCodeField())) continue;
            inner = codeLessResponseBody;
        }
        if (inner == null) {
            return false;
        }
        for (CodeLessResponseBody codeLessResponseBody : codeLessResponseBodies) {
            if (!inner.getParentEntryID().equals(codeLessResponseBody.getEntryID())) continue;
            return "repeat_node".equals(codeLessResponseBody.getParamNode());
        }
        return false;
    }

    public static String isAbleCodelss() {
        Map needParam = CodeLessUtil.getNeedParamPathParent();
        if (needParam.isEmpty() || needParam.size() > 1) {
            logger.error("\u4f4e\u4ee3\u7801\u5904\u7406\u5e73\u53f0\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u8fd4\u56de\u7ed3\u6784\uff0c\u53d1\u73b0\u6709\u591a\u7ea7\u5f85\u89e3\u6790\u8282\u70b9\uff0c\u8bf7\u5f00\u53d1\u5904\u7406");
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u4f4e\u4ee3\u7801\u5904\u7406\u5e73\u53f0\u65e0\u6cd5\u89e3\u6790\u5f53\u524d\u8fd4\u56de\u7ed3\u6784\uff0c\u8bf7\u5f00\u53d1\u5904\u7406", (String)"ParseUtil_0", (String)"ebg-note-business", (Object[])new Object[0]));
        }
        ArrayList list = new ArrayList(needParam.keySet());
        return (String)list.get(0);
    }

    public static String getValue(String rspStr, String type) {
        CodeLess codeLess = EBContext.getContext().getCodeLess();
        if ("xml".equals(codeLess.getContentType())) {
            return XMLParseUtil.getXmlAttrValue(rspStr, type);
        }
        return JSONParseUtil.getJsonAttrValue(rspStr, type);
    }

    public static boolean isNeedInner() {
        Map needParam = CodeLessUtil.getNeedParamPath();
        return !StringUtils.isEmpty((String)needParam.get("inner_code"));
    }

    public static ResponseCode getInnerCode(String rspStr, String app) {
        Map needParam = CodeLessUtil.getNeedParamPath();
        if (StringUtils.isEmpty((String)needParam.get("inner_code"))) {
            logger.info("\u5185\u5c42\u54cd\u5e94\u7801\u7ed3\u6784\u672a\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u9875\u9762\u914d\u7f6e");
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u5185\u5c42\u54cd\u5e94\u7801\u7ed3\u6784\u672a\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u9875\u9762\u914d\u7f6e", (String)"ParseUtil_1", (String)"ebg-note-business", (Object[])new Object[0]));
        }
        String inner_code = ParseUtil.getValue(rspStr, (String)needParam.get("inner_code"));
        String inner_code2 = null;
        String inner_code3 = null;
        if (!StringUtils.isEmpty((String)needParam.get("inner_code2"))) {
            inner_code2 = ParseUtil.getValue(rspStr, (String)needParam.get("inner_code2"));
        }
        if (!StringUtils.isEmpty((String)needParam.get("inner_code3"))) {
            inner_code3 = ParseUtil.getValue(rspStr, (String)needParam.get("inner_code3"));
        }
        String msg = "";
        if (!StringUtils.isEmpty((String)needParam.get("inner_msg"))) {
            msg = ParseUtil.getValue(rspStr, (String)needParam.get("inner_msg"));
        }
        ResponseCode responseCode = new ResponseCode();
        if (!StringUtils.isEmpty(inner_code2)) {
            responseCode.setCode(inner_code + inner_code2);
        } else {
            responseCode.setCode(inner_code);
        }
        responseCode.setMsg(msg);
        String outResult = ParseUtil.getResult(null, inner_code, inner_code2, app, inner_code3);
        responseCode.setResult(outResult);
        return responseCode;
    }

    public static boolean judgeMatch(Map<String, String> mapMatch, Map<String, Object> bankMap, Map<String, String> source) {
        for (String key : mapMatch.keySet()) {
            String sourceValue;
            String bankValue = (String)bankMap.get(key);
            if (StringUtils.equals(bankValue, sourceValue = source.get(mapMatch.get(key)))) continue;
            return false;
        }
        return true;
    }

    public static List<Map<String, Object>> getRepeaterData(String rspStr) {
        CodeLess codeLess = EBContext.getContext().getCodeLess();
        ArrayList<Map<String, Object>> eachData = new ArrayList<Map<String, Object>>(1);
        String valuePath = ParseUtil.isAbleCodelss();
        Map<String, Object> sourceData = null;
        try {
            sourceData = "xml".equals(codeLess.getContentType()) ? XmlToMapUtil.xml2map(rspStr, false) : JsonToMapUtil.json2map(rspStr);
        }
        catch (DocumentException e) {
            logger.error("get repeater data error ", e);
            throw EBExceiptionUtil.serviceException(e);
        }
        return ParseUtil.getData(eachData, sourceData, valuePath);
    }

    public static String getRepeatPath() {
        String needParam = CodeLessUtil.getRepeatPath();
        if (StringUtils.isEmpty(needParam)) {
            return "";
        }
        return needParam;
    }

    public static void getValueByPath(Map map, Map<String, Object> eachRow, String path, List<String> delete, Map jsonMap) {
        String value = (String)ParseUtil.getValueByPath(eachRow, path);
        String[] keys = path.split("\\.");
        if (keys.length > 0) {
            String key = keys[keys.length - 1];
            if (StringUtils.isNotEmpty(key)) {
                if (key.startsWith("@")) {
                    key = key.replaceAll("@", "");
                } else if (key.equals("#text")) {
                    if (keys.length >= 2) {
                        key = keys[keys.length - 2];
                    } else {
                        throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8282\u70b9\u5c5e\u6027\u7ef4\u62a4\u662f\u5426\u5f02\u5e38", (String)"ParseUtil_5", (String)"ebg-note-business", (Object[])new Object[0]));
                    }
                }
            }
            map.put(key, value);
            if (!delete.isEmpty() && delete.contains(path)) {
                jsonMap.put(key, value);
                delete.remove(path);
            }
        }
    }

    public static void getValueByPath(Map map, Map eachRow, String path) {
        String value = (String)ParseUtil.getValueByPath(eachRow, path);
        String[] keys = path.split("\\.");
        if (keys.length > 0) {
            String key = keys[keys.length - 1];
            if (StringUtils.isNotEmpty(key)) {
                if (key.startsWith("@")) {
                    key = key.replaceAll("@", "");
                } else if (key.equals("#text")) {
                    if (keys.length >= 2) {
                        key = keys[keys.length - 2];
                    } else {
                        throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u5185\u5c42\u54cd\u5e94\u7801\u7ed3\u6784\u672a\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u9875\u9762\u914d\u7f6e", (String)"ParseUtil_1", (String)"ebg-note-business", (Object[])new Object[0]));
                    }
                }
            }
            map.put(key, value);
        }
    }

    public static void getValueByPathJson(Map map, Map eachRow, String path) {
        String value = (String)ParseUtil.getValueByPath(eachRow, path);
        String[] keys = path.split("\\.");
        if (keys.length > 0) {
            String key = keys[keys.length - 1];
            map.put(key, value);
        }
    }

    public static <K, V> V getValueByPath(Map<K, V> map, String path) {
        String[] keys = path.split("\\.");
        return ParseUtil.getValueByPath(map, keys, 0);
    }

    private static <K, V> V getValueByPath(Map<K, V> map, String[] keys, int index) {
        if (map == null || index >= keys.length) {
            return null;
        }
        K key = ParseUtil.convertKey(keys[index]);
        V value = map.get(key);
        if (value instanceof Map && index < keys.length - 1) {
            Map nextMap = (Map)value;
            return ParseUtil.getValueByPath(nextMap, keys, index + 1);
        }
        return value;
    }

    private static <K> K convertKey(String keyStr) {
        return (K)keyStr;
    }

    public static List<Map<String, Object>> getData(List<Map<String, Object>> eachData, Map<String, Object> sourceData, String valuePath) {
        if (StringUtils.isEmpty(valuePath)) {
            eachData.add(sourceData);
            return eachData;
        }
        String[] path = valuePath.split("\\.");
        for (int i = 0; i < path.length; ++i) {
            Object object = sourceData.get(path[i]);
            if (i != path.length - 1) {
                if (!(object instanceof Map)) continue;
                sourceData = (Map)object;
                continue;
            }
            if (object instanceof Map || object instanceof JSONObject) {
                Map result = (Map)object;
                eachData.add(result);
                continue;
            }
            eachData = (List)object;
        }
        return eachData;
    }

    public static List<Map<String, Object>> getRepeaterDataWithAttr(String rspStr) {
        CodeLess codeLess = EBContext.getContext().getCodeLess();
        List<Map<String, Object>> eachData = new ArrayList<Map<String, Object>>(1);
        String valuePath = ParseUtil.getRepeatPath();
        Map<String, Object> sourceData = null;
        try {
            if ("xml".equals(codeLess.getContentType())) {
                sourceData = XmlToMapUtil.xml2mapWithAttr(rspStr, true);
            } else if ("json".equals(codeLess.getContentType())) {
                sourceData = JsonToMapUtil.json2map(rspStr);
            }
        }
        catch (DocumentException e) {
            logger.error("get repeater data error ", e);
            throw EBExceiptionUtil.serviceException(e);
        }
        if ("xml".equals(codeLess.getContentType())) {
            List<String> attributeNode = CodeLessUtil.getNodeName(valuePath);
            List<String> jsonMapode = CodeLessUtil.getJsonMapNodeName(valuePath);
            List<String> commonAttributeNode = CodeLessUtil.getCommon(attributeNode);
            attributeNode.removeAll(commonAttributeNode);
            List<String> commonjsonMapNode = CodeLessUtil.getCommon(jsonMapode);
            jsonMapode.removeAll(commonjsonMapNode);
            HashMap commonAttribute = new HashMap(1);
            HashMap commonJsonMap = new HashMap(1);
            for (String string : commonAttributeNode) {
                ParseUtil.getValueByPath(commonAttribute, sourceData, string, commonjsonMapNode, commonJsonMap);
            }
            for (String string : commonjsonMapNode) {
                ParseUtil.getValueByPath(commonJsonMap, sourceData, string);
            }
            eachData = ParseUtil.getData(eachData, sourceData, valuePath);
            ArrayList<Map<String, Object>> mutiData = new ArrayList<Map<String, Object>>(1);
            for (Map<String, Object> map : eachData) {
                HashMap map2 = new HashMap(1);
                HashMap jsonMap = new HashMap(1);
                ArrayList<String> jsonMapodeResult = new ArrayList<String>();
                jsonMapodeResult.addAll(jsonMapode);
                mutiData.add(map2);
                map2.putAll(commonAttribute);
                jsonMap.putAll(commonJsonMap);
                for (String pathOne : attributeNode) {
                    ParseUtil.getValueByPath(map2, map, pathOne, jsonMapodeResult, jsonMap);
                }
                if (!jsonMapodeResult.isEmpty()) {
                    for (String pathOne : jsonMapodeResult) {
                        ParseUtil.getValueByPath(jsonMap, map, pathOne);
                    }
                }
                map2.put("jsonMap", jsonMap);
            }
            return mutiData;
        }
        if ("json".equals(codeLess.getContentType())) {
            eachData = ParseUtil.getData(eachData, sourceData, valuePath);
            List<String> jsonMapode = CodeLessUtil.getJsonMapJson(valuePath);
            ArrayList<Map<String, Object>> mutiData = new ArrayList<Map<String, Object>>(1);
            HashMap jsonMap = new HashMap(1);
            for (Map<String, Object> eachRow : eachData) {
                HashMap map = new HashMap(1);
                for (String string : jsonMapode) {
                    ParseUtil.getValueByPathJson(jsonMap, eachRow, string);
                }
                map.put("jsonMap", jsonMap);
                mutiData.add(map);
            }
            return mutiData;
        }
        return eachData;
    }

    public static Boolean isPassing(Map<String, Object> map, Map<String, String> data) {
        CodeLess codeLess = EBContext.getContext().getCodeLess();
        List<CodeLessResponseBody> responseBodys = codeLess.getResponseBodys();
        for (CodeLessResponseBody info : responseBodys) {
            JudgingConditions rspBody = info.getJudgingCondition();
            if (rspBody == null) continue;
            List<JudgingCondition1> judgingConditionList = rspBody.getJudgingConditionList();
            for (JudgingCondition1 condition : judgingConditionList) {
                String source;
                Boolean isMatch = ParseUtil.getParseConditionsReuslt(condition, map, data);
                if (!isMatch.booleanValue() || !"pass".equals(source = condition.getEbgParamSource())) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, String> getParseResultMap(Map<String, Object> map, Map<String, String> data) {
        CodeLess codeLess = EBContext.getContext().getCodeLess();
        List<CodeLessResponseBody> responseBodys = codeLess.getResponseBodys();
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (CodeLessResponseBody info : responseBodys) {
            JudgingConditionValue notValidValue;
            String injectField;
            JudgingConditions rspBody = info.getJudgingCondition();
            if (rspBody == null) continue;
            Boolean isNeedElse = true;
            List<JudgingCondition1> judgingConditionList = rspBody.getJudgingConditionList();
            for (JudgingCondition1 condition : judgingConditionList) {
                Boolean isMatch = ParseUtil.getParseConditionsReuslt(condition, map, data);
                if (!isMatch.booleanValue()) continue;
                isNeedElse = false;
                injectField = condition.getInjectField();
                String source = condition.getEbgParamSource();
                String value = "";
                if ("ebg_field".equals(source)) {
                    String ebgFieldType = condition.getEbgFieldType();
                    String ebgParam = condition.getEbgParam();
                    value = PackerCommon.getXmlValue(ebgFieldType, data, ebgParam, null, null, null);
                } else if ("default".equals(source)) {
                    value = condition.getValue();
                } else {
                    Map jsonMap = (Map)map.get("jsonMap");
                    value = (String)jsonMap.get(info.getParamName());
                    Function s = null;
                    Class<?> aClass = null;
                    try {
                        aClass = Class.forName("kd.ebg.egf.common.codeless.services.Function");
                        s = (Function)aClass.newInstance();
                    }
                    catch (Exception e) {
                        logger.error("error:", e);
                    }
                    Method declaredMethod = null;
                    try {
                        declaredMethod = aClass.getDeclaredMethod(FuncNameRelection.getValue(source), new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error("error:", e);
                    }
                    try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();){
                        if (declaredMethod != null) {
                            String funcExpression = String.format("services.callBack('%s');", value);
                            context.getBindings("js").putMember("services", (Object)s);
                            context.eval("js", (CharSequence)funcExpression);
                            value = (String)declaredMethod.invoke((Object)s, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        logger.error("error:", e);
                    }
                }
                ParseUtil.MapsAdd(result, injectField, value);
            }
            if (!isNeedElse.booleanValue() || (notValidValue = rspBody.getNotValidValue()) == null) continue;
            String source = notValidValue.getEbgParamSource();
            if ("ebg_field".equals(source)) {
                source = notValidValue.getEbgFieldType();
                String ebgParam = notValidValue.getEbgParam();
                injectField = notValidValue.getInjectField();
                String value = PackerCommon.getXmlValue(source, data, ebgParam, null, null, null);
                ParseUtil.MapsAdd(result, injectField, value);
                continue;
            }
            if ("default".equals(source)) {
                String injectField2 = notValidValue.getInjectField();
                String value = notValidValue.getValue();
                ParseUtil.MapsAdd(result, injectField2, value);
                continue;
            }
            if (!"error".equals(source)) continue;
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u89e3\u6790\u65f6\u6761\u4ef6\u96c6\u5408\u629b\u51fa\u5f02\u5e38", (String)"ParseUtil_0", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        return result;
    }

    public static void MapsAdd(Map<String, String> maps, String key, String value) {
        if (maps.containsKey(key)) {
            String temp = maps.get(key);
            maps.put(key, temp + value);
        } else {
            maps.put(key, value);
        }
    }

    public static Boolean getParseConditionsReuslt(JudgingCondition1 body, Map<String, Object> map, Map<String, String> data) {
        List<JudgingConditionBody> judgingConditionBodys = body.getJudgingConditionBodys();
        if (judgingConditionBodys == null || judgingConditionBodys.size() < 1) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6\u7ed3\u6784\u5f02\u5e38\uff1a%s", (String)"PackerUtil_11", (String)"ebg-note-business", (Object[])new Object[0]), body.getEntryID()));
        }
        StringBuilder expression = new StringBuilder();
        Function s = null;
        Class<?> aClass = null;
        try {
            aClass = Class.forName("kd.ebg.egf.common.codeless.services.Function");
            s = (Function)aClass.newInstance();
        }
        catch (Exception e) {
            logger.error("error:", e);
        }
        for (int i = 0; i < judgingConditionBodys.size(); ++i) {
            JudgingConditionBody judgingConditionBody = judgingConditionBodys.get(i);
            String judgeSource = judgingConditionBody.getEbgParamSource();
            String judgeValue = judgingConditionBody.getNode();
            if ("ebg_field".equals(judgeSource)) {
                judgeSource = judgingConditionBody.getEbgFieldType();
                String paramName = judgingConditionBody.getEbgParam();
                judgeValue = PackerCommon.getXmlValue(judgeSource, data, paramName, null, null, null);
            } else if ("node".equals(judgeSource)) {
                Map jsonMap = (Map)map.get("jsonMap");
                judgeValue = (String)jsonMap.get(judgeValue);
            }
            String filterCompare = judgingConditionBody.getFilterCompare();
            String targertValue = judgingConditionBody.getValue();
            String filterLink = judgingConditionBody.getFilterLink();
            if (i == judgingConditionBodys.size() - 1) {
                filterLink = "";
            }
            Method declaredMethod = null;
            try {
                declaredMethod = aClass.getDeclaredMethod(FuncNameRelection.getValue(filterCompare), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                logger.error("error:", e);
            }
            try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();){
                if (declaredMethod == null) continue;
                String funcExpression = String.format("services.callBack('%1$s', '%2$s');", judgeValue, targertValue);
                context.getBindings("js").putMember("services", (Object)s);
                context.eval("js", (CharSequence)funcExpression);
                Boolean tempResult = (Boolean)declaredMethod.invoke((Object)s, new Object[0]);
                expression.append(tempResult.toString()).append(SPLIT).append(filterLink);
                continue;
            }
            catch (Exception e) {
                logger.error("error:", e);
            }
        }
        Boolean evaluation = null;
        try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();){
            Value js = context.eval("js", (CharSequence)expression.toString());
            evaluation = js.asBoolean();
        }
        catch (Exception e) {
            logger.error(EBExceiptionUtil.stackTraceString(e.getStackTrace()));
        }
        return evaluation;
    }
}

