/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.ParserUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlToMapUtil {
    public static Map<String, Object> xml2map(String xmlStr, boolean needRootKey) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)xmlStr);
        Element root = doc.getRootElement();
        Map<String, Object> map = XmlToMapUtil.xml2map(root);
        if (root.elements().size() == 0 && root.attributes().size() == 0) {
            return map;
        }
        if (needRootKey) {
            HashMap<String, Object> rootMap = new HashMap<String, Object>();
            rootMap.put(root.getName(), map);
            return rootMap;
        }
        return map;
    }

    public static Map<String, Object> xml2mapWithAttr(String xmlStr, boolean needRootKey) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)xmlStr);
        Element root = doc.getRootElement();
        Map<String, Object> map = XmlToMapUtil.elementToMap(root);
        if (root.elements().size() == 0 && root.attributes().size() == 0) {
            return map;
        }
        if (needRootKey) {
            HashMap<String, Object> rootMap = new HashMap<String, Object>();
            rootMap.put(root.getName(), map);
            return rootMap;
        }
        return map;
    }

    private static Map<String, Object> xml2map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Object> mapList = new ArrayList();
                if (iter.elements().size() > 0) {
                    Map<String, Object> m = XmlToMapUtil.xml2map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!(obj instanceof List)) {
                            mapList = new ArrayList();
                            mapList.add(obj);
                            mapList.add(m);
                        }
                        if (obj instanceof List) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!(obj instanceof List)) {
                        mapList = new ArrayList();
                        mapList.add(obj);
                        mapList.add(iter.getText());
                    }
                    if (obj instanceof List) {
                        mapList = (List)obj;
                        mapList.add(iter.getText());
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static Map<String, Object> elementToMap(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        List attributes = element.attributes();
        HashMap<String, String> attrMap = new HashMap<String, String>(1);
        for (Attribute attribute : attributes) {
            attrMap.put("@" + attribute.getName(), attribute.getValue());
        }
        List children = element.elements();
        if (children.isEmpty()) {
            String text = element.getTextTrim();
            if (!text.isEmpty()) {
                map.put("#text", text);
            }
            if (!attrMap.isEmpty()) {
                map.putAll(attrMap);
            }
        } else {
            for (Element child : children) {
                String childName = child.getName();
                if (map.containsKey(childName)) {
                    Object existingValue = map.get(childName);
                    if (!(existingValue instanceof List)) {
                        ArrayList list = new ArrayList();
                        list.add(existingValue);
                        map.put(childName, list);
                    }
                    ((List)map.get(childName)).add(XmlToMapUtil.elementToMap(child));
                    continue;
                }
                map.put(childName, XmlToMapUtil.elementToMap(child));
            }
        }
        if (!attrMap.isEmpty()) {
            map.putAll(attrMap);
        }
        return map;
    }
}

