/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.exception;

import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class EBBaseException
extends RuntimeException {
    public static final String ERROR_CODE = "base_error";
    private String errorCode = "base_error";

    public EBBaseException() {
    }

    public EBBaseException(String message) {
        super(StringUtils.norm(message));
        this.RecordContext(message);
    }

    public EBBaseException(String errorCode, String message) {
        super(StringUtils.norm(message));
        this.errorCode = errorCode;
        this.RecordContext(message);
    }

    public EBBaseException(Throwable cause) {
        super(cause);
        this.RecordContext(cause.getMessage());
    }

    protected EBBaseException(String message, Throwable cause) {
        super(StringUtils.norm(message), cause);
        this.RecordContext(message);
    }

    protected EBBaseException(String errorCode, String message, Throwable cause) {
        super(StringUtils.norm(message), cause);
        this.errorCode = errorCode;
        this.RecordContext(message);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    private void RecordContext(String message) {
        if (message == null || message.length() == 0) {
            message = "error";
        }
        if (EBContext.getContext() != null) {
            RequestContextUtils.setRunningParam("Exception", StringUtils.norm(message));
        }
    }
}

