/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class JarFileReaderUtil {
    public static String read(String fileName, Charset charset) throws IOException {
        String result = "";
        try (InputStream inputStream = JarFileReaderUtil.getResourceAsStream(fileName);){
            if (inputStream != null) {
                result = IOUtils.toString((InputStream)inputStream, (Charset)charset);
            }
        }
        return result;
    }

    public static String read(String fileName) throws IOException {
        return JarFileReaderUtil.read(fileName, StandardCharsets.UTF_8);
    }

    private static InputStream getResourceAsStream(String fileName) {
        InputStream inputStream = JarFileReaderUtil.class.getClassLoader().getResourceAsStream(fileName);
        if (inputStream == null) {
            inputStream = JarFileReaderUtil.class.getClassLoader().getResourceAsStream(fileName.startsWith("/") ? fileName : "/" + fileName);
        }
        return inputStream;
    }
}

