/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.bank.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceptionEnum;
import kd.ebg.egf.common.framework.bank.api.IBankInterfaceLimit;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.utils.string.StrUtil;

public abstract class AbstractBankXmlImpl
extends AbstractImpl
implements IBankInterfaceLimit {
    protected AtomicLong lastInvokeTimestamp = new AtomicLong(0L);
    private static final int USE_CODE_LIMIT = -1;
    public static final int PROCESS_PACK = EBExceptionEnum.PACK_EXCEPTION.getId();
    public static final int PROCESS_CONNECTION = EBExceptionEnum.CONNECTION_EXCEPTION.getId();
    public static final int PROCESS_CONNECTED = EBExceptionEnum.CONNECTED_EXCEPTION.getId();
    public static final int PROCESS_PARSE = EBExceptionEnum.PARSE_EXCEPTION.getId();
    public static final int PROXY_PROCESS_PACK = EBExceptionEnum.PROXY_PACK_EXCEPTION.getId();
    public static final int PROXY_PROCESS_CONNECTION = EBExceptionEnum.PROXY_CONNECTION_EXCEPTION.getId();
    public static final int PROXY_PROCESS_CONNECTED = EBExceptionEnum.PROXY_CONNECTED_EXCEPTION.getId();
    public static final int PROXY_PROCESS_PARSE = EBExceptionEnum.PROXY_PARSE_EXCEPTION.getId();
    public static final int SIGN_PROCESS_PACK = EBExceptionEnum.SIGN_PACK_EXCEPTION.getId();
    public static final int SIGN_PROCESS_CONNECTION = EBExceptionEnum.SIGN_CONNECTION_EXCEPTION.getId();
    public static final int SIGN_PROCESS_CONNECTED = EBExceptionEnum.SIGN_CONNECTED_EXCEPTION.getId();
    public static final int SIGN_PROCESS_PARSE = EBExceptionEnum.SIGN_PARSE_EXCEPTION.getId();
    public static final int LOGIN_PROCESS_PACK = EBExceptionEnum.LOGIN_PACK_EXCEPTION.getId();
    public static final int LOGIN_PROCESS_CONNECTION = EBExceptionEnum.LOGIN_CONNECTION_EXCEPTION.getId();
    public static final int LOGIN_PROCESS_CONNECTED = EBExceptionEnum.LOGIN_CONNECTED_EXCEPTION.getId();
    public static final int LOGIN_PROCESS_PARSE = EBExceptionEnum.LOGIN_PARSE_EXCEPTION.getId();
    private static final String PAGE_KEY = "pageKey";
    private static final String LAST_PAGE_KEY = "lastPageKey";

    @Override
    public final long getInterval() {
        String customID = EBContext.getContext().getCustomID();
        String className = this.getClass().getName();
        long interval = -1L;
        if (interval == -1L) {
            interval = this.getBankInterval();
        }
        return interval;
    }

    @Override
    public final synchronized boolean canDoIt() {
        boolean canDo;
        long now = System.currentTimeMillis();
        boolean bl = canDo = now - this.lastInvokeTimestamp.get() > this.getInterval();
        if (canDo) {
            this.lastInvokeTimestamp.set(now);
        }
        return canDo;
    }

    protected void setCurrentPage(Object value) {
        String page = String.valueOf(value);
        if (StrUtil.isNotBlank(page)) {
            RequestContextUtils.setRunningParam(PAGE_KEY, page);
        }
    }

    protected String getCurrentPage() {
        return RequestContextUtils.getRunningParam(PAGE_KEY);
    }

    protected void setLastPage(boolean lastPage) {
        RequestContextUtils.setRunningParam(LAST_PAGE_KEY, String.valueOf(lastPage));
    }

    protected boolean isLastPage() {
        return Boolean.parseBoolean(RequestContextUtils.getRunningParam(LAST_PAGE_KEY));
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isPackerAuto() {
        return false;
    }

    public boolean isParserAuto() {
        return false;
    }

    public Map<String, String> getStructMapPacker() {
        return new HashMap<String, String>(1);
    }

    public String getStructIdPacker() {
        return "";
    }

    public Map<String, String> getStructMapParser() {
        return new HashMap<String, String>(1);
    }

    public String getDateStr() {
        return "yyyyMMdd";
    }

    public boolean isNeedHead() {
        return false;
    }

    public String getSendMsg(String rqs) {
        return rqs;
    }

    public boolean isNeedPreParse() {
        return false;
    }

    public String getReceiveMsg(String rqs) {
        return rqs;
    }
}

