/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.bank.impl;

import io.netty.handler.codec.http.HttpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.SSLConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AbstractImpl {
    EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractImpl.class);
    private static final String defaultFormKey = "key";
    private static final String defaultFileName = "upload.txt";
    public static String end = "\r\n";
    public static String twoHyphens = "--";
    public static String BOUNDARY = "*****luolei";
    private OutputStream outputStream = null;

    public boolean isForm() {
        return false;
    }

    public boolean isFormFile() {
        return false;
    }

    public boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }

    public String getFormKey() {
        return null;
    }

    public String fileName() {
        return null;
    }

    public boolean isRemoveResponseWrite() {
        return false;
    }

    public void writeResponseLogger(String message) {
        boolean isRemoveWrite = this.isRemoveResponseWrite();
        EBContext ebContext = EBContext.getContext();
        if (ebContext != null && ebContext.isRemoveWriteResponseLog()) {
            isRemoveWrite = true;
        }
        if (isRemoveWrite) {
            if (StringUtils.isNotEmpty(message) && message.length() < 200) {
                this.logger.info("\u54cd\u5e94\u62a5\u6587\uff1a\n" + message);
            }
            return;
        }
        String type = "response";
        if (StringUtils.isEmpty(EBContext.getContext().getLogBizSeqID())) {
            EBContext.getContext().setLogBizSeqID(Sequence.gen18Sequence());
        }
        EBContext.getContext().setType(type);
        this.logger.infoFilerLog(message);
    }

    public String recv(InputStream inputStream) {
        if (this.isSSLProxyConnection()) {
            try {
                SSLConnection connection = (SSLConnection)EBContext.getContext().getConnection();
                String msg = connection.getResponse(inputStream);
                this.writeResponseLogger(String.format(ResManager.loadKDString((String)"SSL\u63a5\u6536\u5230\u7684\u54cd\u5e94%1$s\uff0c%2$s\u3002", (String)"SSLConnection_9", (String)"ebg-egf-common", (Object[])new Object[0]), "\n", msg));
                return msg;
            }
            catch (Exception e) {
                if (StringUtils.isEmpty(e.getMessage())) {
                    throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u8f93\u5165\u6d41\u83b7\u53d6\u5f02\u5e38\u3002", (String)"AbstractImpl_0", (String)"ebg-egf-common", (Object[])new Object[0]), e);
                }
                if (e instanceof EBServiceException) {
                    throw EBExceiptionUtil.serviceException(e.getMessage(), ((EBServiceException)e).getErrorCode(), e);
                }
                throw EBExceiptionUtil.serviceException(e.getMessage(), e);
            }
        }
        String msg = IOUtils.readFully(inputStream);
        this.writeResponseLogger(String.format(ResManager.loadKDString((String)"\u63a5\u6536\u5230\u7684\u54cd\u5e94%1$s %2$s", (String)"SSLConnection_7", (String)"ebg-egf-common", (Object[])new Object[0]), "\n", msg));
        return msg;
    }

    public InputStream getInputStream(IConnection connection) {
        try {
            return connection.getInputStream();
        }
        catch (IOException e) {
            String errorMsg = ResManager.loadKDString((String)"\u8f93\u5165\u6d41\u83b7\u53d6\u5f02\u5e38\u3002", (String)"AbstractImpl_0", (String)"ebg-egf-common", (Object[])new Object[0]);
            if (!StringUtils.isEmpty(e.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8f93\u5165\u6d41\u5f02\u5e38,%s", (String)"AbstractImpl_1", (String)"ebg-egf-common", (Object[])new Object[0]), e.getMessage());
            }
            throw EBExceiptionUtil.serviceException(errorMsg, e);
        }
    }

    public void send(OutputStream outputStream, String requestStr) {
        if (this.isSSLProxyConnection()) {
            SSLConnection connection = (SSLConnection)EBContext.getContext().getConnection();
            connection.sendMsg(outputStream, requestStr);
        } else if (this.isFormFile()) {
            this.sendFileForm(outputStream, requestStr, StringUtils.isEmpty(this.getFormKey()) ? defaultFormKey : this.getFormKey(), StringUtils.isEmpty(this.fileName()) ? this.fileName() : defaultFileName);
        } else if (this.isForm()) {
            this.sendForm(outputStream, requestStr, StringUtils.isEmpty(this.getFormKey()) ? defaultFormKey : this.getFormKey());
        } else {
            IOUtils.sendFully(outputStream, requestStr);
        }
    }

    public void sendForm(OutputStream outputStream, String rqstStr, String formKey) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(formKey).append("=").append(URLEncoder.encode(rqstStr, RequestContextUtils.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"form \u8868\u5355\u683c\u5f0f\u8f6c\u6362\u5931\u8d25", (String)"AbstractImpl_2", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
        IOUtils.sendFully(outputStream, sb.toString());
    }

    public void sendFileForm(OutputStream outputStream, String rqstStr, String formKey, String fileName) {
        String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
        String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n\r\n";
        StringBuilder builder = StrUtil.builder().append("--").append(BOUNDARY).append("\r\n");
        builder.append(StrUtil.format(CONTENT_DISPOSITION_FILE_TEMPLATE, formKey, fileName));
        builder.append(StrUtil.format(CONTENT_TYPE_FILE_TEMPLATE, HttpUtil.getMimeType((CharSequence)fileName)));
        builder.append(rqstStr).append("\r\n");
        builder.append(StrUtil.format("--{}--\r\n", BOUNDARY));
        IOUtils.sendFully(outputStream, builder.toString());
    }

    public OutputStream getOutputStream(IConnection connection) {
        try {
            return connection.getOutputStream();
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException(ResManager.loadKDString((String)"\u83b7\u53d6\u8f93\u51fa\u6d41\u5f02\u5e38\u3002", (String)"AbstractImpl_3", (String)"ebg-egf-common", (Object[])new Object[0]), e);
        }
    }

    public void openConnection(IConnection connection) {
        try {
            EBContext.getContext().setConnection(connection);
            connection.openConnection();
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException(e.getMessage(), e);
        }
    }

    public void closeConnection(IConnection connection) {
        if (this.isSSLProxyConnection()) {
            connection.closeConnection();
        }
    }

    public IConnection getConnection(ConnectionFactory factory) {
        return factory.createExchangeConnection();
    }

    public IConnection getSignConnection(ConnectionFactory factory) {
        return factory.createSignConnection();
    }

    public IConnection getFrontProxyConnection(ConnectionFactory factory) {
        return factory.createFrontProxyConnection();
    }

    public IConnection getFrontProxyExtConnection(ConnectionFactory factory) {
        return factory.createFrontProxyExtConnection();
    }

    public IConnection getFileConnection(ConnectionFactory factory) {
        return factory.createFileConnection();
    }

    public IConnection getAppointConnection(ConnectionFactory factory, String protocol, String ip, String prot, String timeOut) {
        return factory.createAppointConnection(protocol, ip, prot, timeOut);
    }

    public IConnection getAppointHttpConnection(ConnectionFactory factory, String ip, String port, String timeOut) {
        return this.getAppointConnection(factory, "HTTP", ip, port, timeOut);
    }

    public IConnection getAppointTcpConnection(ConnectionFactory factory, String ip, String port, String timeOut) {
        return this.getAppointConnection(factory, "TCP", ip, port, timeOut);
    }

    public IConnection getValidateConnection(ConnectionFactory factory) {
        return factory.createValidateConnection();
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        this.configFactory(factory);
        return factory;
    }

    public void closeOutputStreamQuietly(OutputStream outputStream) {
        if (this.isSSLProxyConnection()) {
            this.outputStream = outputStream;
        } else {
            IOUtils.closeOutputStreamQuietly(outputStream);
        }
    }

    public void closeInputStreamQuietly(InputStream inputStream) {
        if (this.isSSLProxyConnection()) {
            IOUtils.closeOutputStreamQuietly(this.outputStream);
        }
        IOUtils.closeInputStreamQuietly(inputStream);
    }

    public void configFactory(ConnectionFactory factory) {
    }
}

