/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.protocol.HttpsClient;
import kd.ebg.egf.common.utils.string.StringUtils;

public class HttpsConnection
implements IConnection {
    public static final String REQUEST_METHOD_POST = "POST";
    public static final String REQUEST_METHOD = "Request Method";
    private HttpsClient httpsClient;
    private String host;
    private int port;
    private String uri;
    private Map<String, String> header;
    private int timeout;
    private String method;

    public HttpsConnection(String host, int port, String uri, Map<String, String> header, int timeout) {
        this(host, port, uri, header, timeout, REQUEST_METHOD_POST);
    }

    public HttpsConnection(String host, int port, String uri, Map<String, String> header, int timeout, String method) {
        this.host = host;
        this.port = port;
        this.uri = uri;
        this.header = header;
        this.timeout = timeout;
        this.method = method;
    }

    @Override
    public void openConnection() throws IOException {
        this.httpsClient = new HttpsClient(this.host, this.port, this.uri, this.header, this.timeout, this.method);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.httpsClient.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.httpsClient.getOutputStream();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.httpsClient.getResponseCode();
    }

    @Override
    public void closeConnection() {
        this.httpsClient.closeConnection();
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(this.host).append(':').append(this.port);
        if (!StringUtils.isEmpty(this.uri)) {
            if (this.uri.startsWith("/")) {
                sb.append(this.uri);
            } else {
                sb.append('/').append(this.uri);
            }
        }
        return sb.toString();
    }

    public String getHttpsHeaderField(String key) {
        return this.httpsClient.getConnection().getHeaderField(key);
    }
}

