/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.frontProxy.login;

import java.util.concurrent.TimeUnit;
import kd.bos.dlock.DLock;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frontProxy.AbstractFrontProxyImpl;
import kd.ebg.egf.common.framework.frontProxy.ParamUtil;
import kd.ebg.egf.common.framework.frontProxy.SMUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class LoginImpl
extends AbstractFrontProxyImpl {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(LoginImpl.class);
    private String token;
    private static final int timeout = 28;

    public synchronized String getToken() {
        String key = this.getCacheKey();
        String cache_token = CosmicCache.get(key);
        if (StringUtils.isEmpty(cache_token)) {
            DLock lock = DLock.create((String)key, (String)"proxy token lock");
            try {
                if (lock.tryLock()) {
                    cache_token = CosmicCache.get(key);
                    if (cache_token == null) {
                        this.login();
                        CosmicCache.putIfAbsentWithExpire(key, this.token, 28, TimeUnit.MINUTES);
                        cache_token = this.token;
                    }
                } else {
                    long time;
                    for (time = 60000L; time >= 0L && (cache_token = CosmicCache.get(key)) == null; time -= 700L) {
                        Thread.sleep(700L);
                    }
                    if (time < 0L) {
                        throw EBExceiptionUtil.serviceException("request proxy token error");
                    }
                }
            }
            catch (Exception e) {
                log.error(String.format("\u83b7\u53d6\u4ee3\u7406\u7a0b\u5e8ftoken\u51fa\u73b0\u5f02\u5e38,%s", e.getMessage()));
                throw EBExceiptionUtil.serviceException(e.getMessage(), e);
            }
            finally {
                lock.unlock();
            }
        }
        return cache_token;
    }

    private void login() {
        try {
            String sendMsg = this.packLogin();
            String recMsg = this.sendAndRecvMsgNormor(sendMsg);
            this.token = this.parseLogin(recMsg);
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            throw EBExceiptionUtil.serviceException(e.getMessage(), e);
        }
    }

    private String getCacheKey() {
        return "ebg_proxy_token";
    }

    public String packLogin() throws Exception {
        Element root = new Element("root");
        JDomUtils.addChild(root, "transcode", "login");
        JDomUtils.addChild(root, "content", SMUtil.encrypt(this.packContent()));
        return JDomUtils.root2String(root, "GBK");
    }

    public String parseLogin(String rspStr) throws Exception {
        Element root = JDomUtils.string2Root(rspStr, "GBK");
        String content = root.getChildTextTrim("content");
        rspStr = SMUtil.deCipher(content);
        root = JDomUtils.string2Root(rspStr, "GBK");
        return root.getChildTextTrim("token");
    }

    public String packContent() throws Exception {
        Element root = new Element("root");
        JDomUtils.addChild(root, "user", ParamUtil.proxyAuthorName());
        JDomUtils.addChild(root, "pwd", ParamUtil.proxyAuthorPwd());
        return JDomUtils.root2String(root, "GBK");
    }
}

