/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.lock.redis;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lock.AccessManager;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.LeaseEnum;
import kd.ebg.egf.common.framework.lock.redis.RedisFepAccess;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.utils.string.StringUtils;

public class RedisAccessManager
implements AccessManager {
    public static final String CLUSTER_NAME = "clusterName";
    private static RedisAccessManager instance = new RedisAccessManager();
    private ConcurrentMap<String, Map<String, FEPAccess>> fepAccessConcurrentMap = new ConcurrentHashMap<String, Map<String, FEPAccess>>(16);

    public static RedisAccessManager getInstance() {
        return instance;
    }

    @Override
    public FEPAccess getAccess(String customerId, String bankVersionId, String bankLoginId) {
        String acKey = this.getFEPAccessKey(customerId);
        if (this.fepAccessConcurrentMap.containsKey(acKey)) {
            if (!((Map)this.fepAccessConcurrentMap.get(acKey)).containsKey(bankLoginId)) {
                this.ensureExist(customerId, bankVersionId, bankLoginId);
            }
        } else {
            this.ensureExist(customerId, bankVersionId, bankLoginId);
        }
        return (FEPAccess)((Map)this.fepAccessConcurrentMap.get(acKey)).get(bankLoginId);
    }

    private synchronized void ensureExist(String customerId, String bankVersionId, String bankLoginId) {
        String acKey = this.getFEPAccessKey(customerId);
        Map loginIdAccessMap = this.fepAccessConcurrentMap.getOrDefault(acKey, new ConcurrentHashMap(16));
        if ((loginIdAccessMap = this.fepAccessConcurrentMap.putIfAbsent(acKey, loginIdAccessMap)) == null) {
            loginIdAccessMap = this.fepAccessConcurrentMap.getOrDefault(acKey, new ConcurrentHashMap(16));
        }
        if (!loginIdAccessMap.containsKey(bankLoginId)) {
            BankLoginConfigKey key = new BankLoginConfigKey();
            key.setBankLoginId(bankLoginId);
            key.setBankVersionId(bankVersionId);
            key.setCustomID(customerId);
            key.setBankConfigId(LeaseEnum.getEnumNameByID(this.getAppID()));
            int concurrentCount = this.getBankLoginLeaseNum(key);
            String accountId = RequestContext.get().getAccountId();
            String nodeKey = customerId + "/" + accountId + "/" + this.getAppID() + "/" + bankVersionId + "/" + bankLoginId;
            if (this.isShareDLOCK(bankVersionId)) {
                String clusterName = System.getProperty(CLUSTER_NAME);
                nodeKey = customerId + "/" + clusterName + "/" + this.getAppID() + "/" + bankVersionId + "/" + bankLoginId;
            }
            RedisFepAccess access = new RedisFepAccess(nodeKey, concurrentCount);
            loginIdAccessMap.put(bankLoginId, access);
        }
    }

    private int getBankLoginLeaseNum(BankLoginConfigKey key) {
        try {
            String leaseNumStr = BankLoginConfigService.getInstance().getBankLoginConfigValue(key);
            if (StringUtils.isNotEmpty(leaseNumStr) && StringUtils.isNumeric(leaseNumStr)) {
                return Integer.parseInt(leaseNumStr);
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private String getFEPAccessKey(String customerId) {
        String accountId = RequestContext.get().getAccountId();
        String acKey = customerId + "_" + accountId + "_" + this.getAppID();
        return acKey;
    }

    private String getAppID() {
        String appid = "ebg";
        EBContext context = EBContext.getContext();
        if (context != null) {
            String businessType = context.getBizName();
            QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{businessType});
            try {
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_business_type", (String)"appid", (QFilter[])filter.toArray());
                if (object != null) {
                    appid = object.getString("appid");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return appid;
    }

    private boolean isShareDLOCK(String bankVersionId) {
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setCustomID(RequestContext.get().getTenantId());
        key.setAttrKey("bank_share_dlock");
        key.setObjectID(bankVersionId);
        key.setObjectName("BANK_BUSINESS");
        String value = ObjectPropertyService.getInstance().getPropertyValue(key);
        return Boolean.parseBoolean(value);
    }
}

