/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.factory;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.framework.security.api.ICustomerInfoProvider;
import kd.ebg.egf.common.framework.service.tenant.TenantService;
import kd.ebg.egf.common.model.tenant.CustomerInfo;
import kd.ebg.egf.common.model.tenant.TenantAuth;
import kd.ebg.egf.common.repository.tenant.TenantAuthRepository;
import org.bouncycastle.util.encoders.Base64;

public class DataBaseCustomerInfoProvider
implements ICustomerInfoProvider {
    @Override
    public CustomerInfo getCustomerInfoByID(String customerID) {
        TenantAuth tenantAuth;
        CustomerInfo info = new CustomerInfo();
        TenantAuthRepository authRepository = TenantAuthRepository.getInstance();
        List<TenantAuth> tenantAuths = null;
        tenantAuths = DataBaseCustomerInfoProvider.isJDY(customerID) ? authRepository.findAll() : authRepository.findByCustomID(customerID);
        if (tenantAuths.size() > 0) {
            tenantAuth = tenantAuths.get(0);
            if (tenantAuth.getExpireTime().isBefore(LocalDateTime.now())) {
                throw new EBSecurityException(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u5ba2\u6237\u8ba4\u8bc1\u4fe1\u606f\uff08CA\u8bc1\u4e66\uff09\u5df2\u8fc7\u671f", (String)"DataBaseCustomerInfoProvider_0", (String)"ebg-egf-common", (Object[])new Object[0]));
            }
        } else {
            throw new EBSecurityException(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u5ba2\u6237\u8ba4\u8bc1\u4fe1\u606f\uff08CA\u8bc1\u4e66\uff09\u4e0d\u5b58\u5728", (String)"DataBaseCustomerInfoProvider_1", (String)"ebg-egf-common", (Object[])new Object[0]));
        }
        info.setCustomerID(customerID);
        info.setPublicKey(Base64.decode((String)tenantAuth.getPublicKey()));
        info.setExpireDate(tenantAuth.getExpireTime());
        info.setCommonName(tenantAuth.getCommonName());
        info.setOrganizationalUnit(tenantAuth.getOrganization());
        return info;
    }

    public CustomerInfo getCustomerInfoByCustomID(String customerID) {
        CustomerInfo info = new CustomerInfo();
        TenantAuthRepository authRepository = TenantAuthRepository.getInstance();
        List<TenantAuth> tenantAuths = DataBaseCustomerInfoProvider.isJDY(customerID) ? authRepository.findAll() : authRepository.findByCustomID(customerID);
        if (tenantAuths.size() > 0) {
            TenantAuth tenantAuth = tenantAuths.get(0);
            info.setCustomerID(customerID);
            info.setPublicKey(Base64.decode((String)tenantAuth.getPublicKey()));
            info.setExpireDate(tenantAuth.getExpireTime());
            info.setCommonName(tenantAuth.getCommonName());
            info.setOrganizationalUnit(tenantAuth.getOrganization());
        }
        return info;
    }

    private static boolean isJDY(String customerID) {
        TenantService tenantService = TenantService.getInstance();
        if (tenantService.isJDY(customerID)) {
            return true;
        }
        return customerID.startsWith("JDY") || customerID.startsWith("YKJ") || customerID.startsWith("PRO");
    }
}

