/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.security.factory;

import java.io.ByteArrayInputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.framework.security.reader.P12CertReader;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class EBKeyProvider {
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private static EBKeyProvider instance = new EBKeyProvider();

    public static EBKeyProvider getInstance() {
        return instance;
    }

    public void init(String certContent, String certPwd, String alias, AESCipherSecurity aesCipherSecurity) {
        try {
            byte[] encryptBytes = Base64.decodeBase64((String)certContent);
            CipherInfo cipherInfo = aesCipherSecurity.getCipherInfo(certContent);
            byte[] bytes = aesCipherSecurity.decryptToByte(encryptBytes, aesCipherSecurity.getCipherInfo(cipherInfo.getCipherVersion()));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            P12CertReader p12CertReader = new P12CertReader(inputStream, certPwd, alias);
            p12CertReader.initKeyStore();
            this.privateKey = p12CertReader.getPrivateKey();
            this.publicKey = p12CertReader.getPublicKey();
        }
        catch (Exception e) {
            throw new EBSecurityException(e);
        }
    }

    private void initFromDB() {
        QFilter filter = QFilter.of((String)"file_name=? and bank_config_id=?", (Object[])new Object[]{"ebg_formal.p12", "private_key"});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_bd_cert", (String)"bank_config_value, bank_config_value_tag", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            String certCipher = dynamicObject.getString("bank_config_value");
            String certContent = dynamicObject.getString("bank_config_value_tag");
            AESCipherSecurity aesCipherSecurity = AESCipherSecurity.getInstance();
            if (StringUtils.isNotEmpty(certCipher)) {
                CipherInfo cipherInfo = aesCipherSecurity.getCipherInfo(certCipher);
                certCipher = aesCipherSecurity.decrypt(certCipher, cipherInfo.getCipherVersion());
                if (StringUtils.isNotEmpty(certContent)) {
                    this.init(certContent, certCipher, "server", aesCipherSecurity);
                }
            }
        }
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey == null) {
            this.initFromDB();
        }
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        if (this.publicKey == null) {
            this.initFromDB();
        }
        return this.publicKey;
    }
}

