/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import kd.ebg.egf.common.utils.string.StrUtil;

public class SftpClientImp {
    private ChannelSftp sftp;
    private String host;
    private int port;
    private String userName;
    private String cipher;
    private String certPath;
    private int sessionTimeout;
    private int connectTimeout;

    public SftpClientImp(String host, int port, String userName, String cipher, String cert, int sessionTimeout) {
        this(host, port, userName, cipher, cert, sessionTimeout, 2000);
    }

    public SftpClientImp(String host, int port, String userName, String cipher, int sessionTimeout) {
        this(host, port, userName, cipher, "", sessionTimeout, 2000);
    }

    private SftpClientImp(String host, int port, String userName, String cipher, String cert, int sessionTimeout, int connectTimeout) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.cipher = cipher;
        this.sessionTimeout = sessionTimeout;
        this.connectTimeout = connectTimeout;
        this.certPath = cert;
    }

    public void open() throws Exception {
        if (null != this.sftp && this.sftp.isConnected()) {
            return;
        }
        JSch jsch = new JSch();
        Session session = jsch.getSession(this.userName, this.host, this.port);
        if (StrUtil.isEmpty(this.certPath)) {
            session.setPassword(this.cipher);
        } else {
            jsch.addIdentity(this.certPath, this.cipher);
        }
        Properties config = new Properties();
        config.setProperty("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.setTimeout(this.sessionTimeout * 1000);
        session.connect(this.connectTimeout);
        Channel channel = session.openChannel("sftp");
        channel.connect();
        this.sftp = (ChannelSftp)channel;
    }

    public String pwd() throws Exception {
        return this.sftp.pwd();
    }

    public String getHome() throws Exception {
        return this.sftp.getHome();
    }

    public void cd(String path) throws Exception {
        if (!".".equals(path)) {
            this.sftp.cd(path);
        }
    }

    public void back2Home() throws Exception {
        String home = this.getHome();
        String pwd = this.pwd();
        String relativePath = pwd.replaceFirst(home, "");
        String tmp = relativePath.replaceAll("/", "");
        int n = relativePath.length() - tmp.length();
        StringBuilder back2HomePath = new StringBuilder("./");
        for (int i = 0; i < n; ++i) {
            back2HomePath.append("../");
        }
        this.cd(back2HomePath.toString());
    }

    public String[] ls(String path) throws Exception {
        this.cd(path);
        return this.ls();
    }

    public String[] ls() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Vector vv = this.sftp.ls(".");
        if (vv != null) {
            for (int ii = 0; ii < vv.size(); ++ii) {
                ChannelSftp.LsEntry entry;
                Object obj = vv.elementAt(ii);
                if (!(obj instanceof ChannelSftp.LsEntry) || (entry = (ChannelSftp.LsEntry)obj).getAttrs().isDir()) continue;
                list.add(entry.getFilename());
            }
        }
        return list.toArray(new String[0]);
    }

    public String[] lsFile(String file) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Vector vv = this.sftp.ls(file);
        if (vv != null) {
            for (int ii = 0; ii < vv.size(); ++ii) {
                ChannelSftp.LsEntry entry;
                Object obj = vv.elementAt(ii);
                if (!(obj instanceof ChannelSftp.LsEntry) || (entry = (ChannelSftp.LsEntry)obj).getAttrs().isDir()) continue;
                list.add(entry.getFilename());
            }
        }
        return list.toArray(new String[0]);
    }

    public void delete(String path) throws Exception {
        this.sftp.rm(path);
    }

    public InputStream get(String path) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        return this.sftp.get(path, (SftpProgressMonitor)monitor);
    }

    public void get(String path, String localPath) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.sftp.get(path, localPath, (SftpProgressMonitor)monitor);
    }

    public void put(String path, InputStream src) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        int mode = 2;
        this.sftp.put(src, path, (SftpProgressMonitor)monitor, mode);
    }

    public void put(String path, String src) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        int mode = 2;
        this.sftp.put(src, path, (SftpProgressMonitor)monitor, mode);
    }

    public void mkdirIfDirNotExist(String dir) throws Exception {
        boolean existDir = this.isExistDir(dir, this.sftp);
        if (!existDir) {
            this.sftp.mkdir(dir);
        }
    }

    public void close() throws Exception {
        if (this.sftp != null) {
            this.sftp.disconnect();
            this.sftp.getSession().disconnect();
        }
    }

    private boolean isExistDir(String path, ChannelSftp sftp) {
        boolean isExist = false;
        try {
            SftpATTRS sftpATTRS = sftp.lstat(path);
            isExist = true;
            return sftpATTRS.isDir();
        }
        catch (Exception e) {
            if (e.getMessage().equalsIgnoreCase("no such file")) {
                isExist = false;
            }
            return isExist;
        }
    }

    public ChannelSftp getSftp() {
        return this.sftp;
    }

    public void setSftp(ChannelSftp sftp) {
        this.sftp = sftp;
    }

    public String getUrl() {
        return "ftp://" + this.userName + "@" + this.host + ":" + this.port + "/";
    }

    public static class SimpleUserInfo
    implements UserInfo {
        private String passwd;

        public SimpleUserInfo(String passwd) {
            this.passwd = passwd;
        }

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String message) {
        }
    }

    public static class NullProgressMonitor
    implements SftpProgressMonitor {
        public void init(int op, String src, String dest, long max) {
        }

        public boolean count(long count) {
            return true;
        }

        public void end() {
        }
    }
}

