/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.url.UrlService;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.license.LicenseDetailService;
import kd.ebg.egf.common.license.EbgLicenseModuleEnum;
import kd.ebg.egf.common.license.LicenseCache;
import kd.ebg.egf.common.license.TenantInfo;
import kd.ebg.egf.common.license.old.OldLicenseCache;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.license.LicenseDetail;
import kd.ebg.egf.common.model.license.LicenseFile;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.license.LicenseFileRepository;

public class EbgLicenseUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EbgLicenseUtil.class);
    public static final String LICENSE_EBG_GROUP_ID = "523";
    public static final String LICENSE_EBG_NOTE_GROUP_ID = "522";
    private static final String CHECK_LICENSE = "checkLicense";
    private static boolean isCheckLicense = Boolean.parseBoolean(System.getProperty("checkLicense", "true"));
    private static final String LICENSE_COUNT_ZERO = EbgLicenseUtil.getLICENSE_COUNT_ZERO();

    private static String getLICENSE_COUNT_ZERO() {
        return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5e73\u53f0\u8fd4\u56de\u7684\u94f6\u4f01\u670d\u52a1\u5206\u7ec4\u6570\u91cf\u4e3a0\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u5bf9\u5e94\u8bb8\u53ef\u3002", (String)"EbgLicenseUtil_0", (String)"ebg-egf-common", (Object[])new Object[0]);
    }

    public static String getLicenseCountZeroForNote() {
        return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5e73\u53f0\u8fd4\u56de\u7684\u94f6\u4f01\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u63a5\u53e3\u5206\u7ec4\u6570\u91cf\u4e3a0\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u5bf9\u5e94\u8bb8\u53ef\u3002", (String)"EbgLicenseUtil_9", (String)"ebg-egf-common", (Object[])new Object[0]);
    }

    public static boolean isTestEnv() {
        String clientUrl = UrlService.getDomainContextUrl();
        if (clientUrl.contains("https://feature.kingdee.com:1024")) {
            return true;
        }
        return clientUrl.contains("https://feature.kingdee.com:2019");
    }

    public static String checkLicenseValid(String customId, String subBizType, String bankLoginId) {
        if (EbgLicenseUtil.isTestEnv()) {
            return null;
        }
        if (!isCheckLicense) {
            return null;
        }
        LicenseFileRepository licenseFileRepository = LicenseFileRepository.getInstance();
        LicenseFile licenseFile = licenseFileRepository.findByCustomId(customId);
        if (licenseFile != null) {
            return EbgLicenseUtil.checkOldLicense(customId, subBizType, bankLoginId);
        }
        return EbgLicenseUtil.checkNewLicense(customId, subBizType, bankLoginId, false);
    }

    public static String checkLicenseValid(String customId, String subBizType, String bankLoginId, boolean isNeedCheckBrLicense) {
        if (EbgLicenseUtil.isTestEnv()) {
            return null;
        }
        LicenseFileRepository licenseFileRepository = LicenseFileRepository.getInstance();
        LicenseFile licenseFile = licenseFileRepository.findByCustomId(customId);
        if (licenseFile != null) {
            return EbgLicenseUtil.checkOldLicense(customId, subBizType, bankLoginId);
        }
        return EbgLicenseUtil.checkNewLicense(customId, subBizType, bankLoginId, isNeedCheckBrLicense);
    }

    private static String checkOldLicense(String customId, String subBizType, String bankLoginId) {
        EBContext context;
        String bankVersionID;
        TenantInfo tenant = OldLicenseCache.getTenant();
        int totalLicenseCount = tenant.getTotalLicenseCount();
        if (totalLicenseCount == 0) {
            return ResManager.loadKDString((String)"\u68c0\u6d4b\u52304.0\u94f6\u4f01\u4e91\u5206\u7ec4\u6570\u91cf\u4e3a0\uff0c\u8bf7\u786e\u8ba4\u8bb8\u53ef\u4e0a\u4f20\u540e\u91cd\u8bd5\u3002", (String)"EbgLicenseUtil_1", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        String expiredDate = tenant.getExpiredDate();
        if (LocalDate.now().compareTo(LocalDateTime.parse(expiredDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toLocalDate()) > 0) {
            return ResManager.loadKDString((String)"\u94f6\u4f01\u4e914.0\u8bb8\u53ef\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"EbgLicenseUtil_2", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        EbgLicenseModuleEnum ebgLicenseModuleEnum = EbgLicenseUtil.getEbgLicenseModuleEnum(subBizType);
        if (EbgLicenseModuleEnum.BR.getModuleCode().equalsIgnoreCase(ebgLicenseModuleEnum.getModuleCode())) {
            return ResManager.loadKDString((String)"\u94f6\u4f014.0\u8bb8\u53ef\u4e0d\u652f\u6301\u4f59\u989d\u5bf9\u8d26\u529f\u80fd\uff0c\u8bf7\u4f7f\u7528\u94f6\u4f01\u4e915.0\u53ca\u4ee5\u4e0a\u7248\u672c\u8bb8\u53ef\u3002", (String)"EbgLicenseUtil_13", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        if (EbgLicenseModuleEnum.CCY_PAY.getModuleCode().equalsIgnoreCase(ebgLicenseModuleEnum.getModuleCode())) {
            return ResManager.loadKDString((String)"\u94f6\u4f014.0\u8bb8\u53ef\u4e0d\u652f\u6301\u4e2d\u8d44\u94f6\u884c\u5916\u5e01\u652f\u4ed8\u529f\u80fd\uff0c\u8bf7\u4f7f\u7528\u94f6\u4f01\u4e915.0\u53ca\u4ee5\u4e0a\u7248\u672c\u8bb8\u53ef\u3002", (String)"EbgLicenseUtil_14", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        String moduleName = ebgLicenseModuleEnum.getModuleName();
        String moduleCode = ebgLicenseModuleEnum.getModuleCode();
        int unusedLicenseCount = tenant.getUnusedLicenseCount();
        if (unusedLicenseCount < 0) {
            return ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e34.0\u8bb8\u53ef\u5206\u7ec4\u6570\u91cf\u5c0f\u4e8e\u5df2\u5360\u7528\u8bb8\u53ef\u6570\u91cf\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u4e1a\u52a1\uff0c\u8bf7\u5728\u94f6\u4f01\u4e914.0\u8bb8\u53ef\u4fe1\u606f\u4e2d\u67e5\u770b\u8be6\u60c5\u3002", (String)"EbgLicenseUtil_3", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        LicenseDetailService licenseDetailService = LicenseDetailService.getInstance();
        boolean moduleExist = licenseDetailService.isModuleExist(moduleCode, bankVersionID = (context = EBContext.getContext()).getBankVersionID(), customId);
        if (moduleExist) {
            return null;
        }
        if (tenant.getUnusedLicenseCount() < 1) {
            return ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3\u8bb8\u53ef\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u4e1a\u52a1\uff0c\u8bf7\u5728\u94f6\u4f01\u4e914.0\u8bb8\u53ef\u4fe1\u606f\u4e2d\u67e5\u770b\u8be6\u60c5\u3002", (String)"EbgLicenseUtil_4", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        EbgLicenseUtil.saveLicenseDetail(customId, bankLoginId, bankVersionID, moduleName, moduleCode, licenseDetailService);
        return null;
    }

    private static String getCacheKey() {
        String customID = EBContext.getContext().getCustomID();
        String bankVersionID = EBContext.getContext().getBankVersionID();
        return "eb_" + customID + "_" + bankVersionID + "_" + EbgLicenseModuleEnum.PAY.getModuleCode();
    }

    private static String checkNewLicense(String customId, String subBizType, String bankLoginId, boolean isNeedCheckBrLicense) {
        EBContext context;
        String bankVersionID;
        EbgLicenseModuleEnum ebgLicenseModuleEnum = EbgLicenseUtil.getEbgLicenseModuleEnum(subBizType);
        if (!isNeedCheckBrLicense && ebgLicenseModuleEnum.getModuleCode().equalsIgnoreCase(EbgLicenseModuleEnum.BR.getModuleCode())) {
            return null;
        }
        TenantInfo tenant = LicenseCache.getTenant();
        int totalLicenseCount = tenant.getTotalLicenseCount();
        if (totalLicenseCount == 0) {
            return LICENSE_COUNT_ZERO;
        }
        LocalDateTime deadline = tenant.getDeadline();
        if (LocalDate.now().compareTo(deadline.toLocalDate()) > 0) {
            return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5e73\u53f0\u8fd4\u56de\u7684\u94f6\u4f01\u670d\u52a1\u5206\u7ec4\u8bb8\u53ef\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u4e0a\u4f20\u540e\u518d\u6b21\u540c\u6b65\u8bb8\u53ef\u3002", (String)"EbgLicenseUtil_6", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        int unusedLicenseCount = tenant.getUnusedLicenseCount();
        if (unusedLicenseCount < 0) {
            return ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3\u7684\u8bb8\u53ef\u5206\u7ec4\u6570\u91cf\u5c0f\u4e8e\u5df2\u5360\u7528\u8bb8\u53ef\u6570\u91cf\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u4e1a\u52a1\uff0c\u8bf7\u5728\u8bb8\u53ef\u4fe1\u606f\u4e2d\u67e5\u770b\u8be6\u60c5\u3002", (String)"EbgLicenseUtil_7", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        String moduleName = ebgLicenseModuleEnum.getModuleName();
        String moduleCode = ebgLicenseModuleEnum.getModuleCode();
        LicenseDetailService licenseDetailService = LicenseDetailService.getInstance();
        boolean moduleExist = licenseDetailService.isModuleExist(moduleCode, bankVersionID = (context = EBContext.getContext()).getBankVersionID(), customId);
        if (moduleExist) {
            return null;
        }
        if (tenant.getUnusedLicenseCount() < 1) {
            return ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3\u8bb8\u53ef\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u4e1a\u52a1\uff0c\u8bf7\u5728\u8bb8\u53ef\u4fe1\u606f\u4e2d\u67e5\u770b\u8be6\u60c5\u3002", (String)"EbgLicenseUtil_8", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        EbgLicenseUtil.saveLicenseDetail(customId, bankLoginId, bankVersionID, moduleName, moduleCode, licenseDetailService);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveLicenseDetail(String customId, String bankLoginId, String bankVersionID, String moduleName, String moduleCode, LicenseDetailService licenseDetailService) {
        logger.info("\u94f6\u884c:{}\uff0c\u8fd8\u672a\u5360\u7528\u8bb8\u53ef\uff0c\u51c6\u5907\u6263\u51cf", (Object)bankVersionID);
        LicenseDetail licenseDetail = new LicenseDetail();
        licenseDetail.setCustomId(customId);
        licenseDetail.setModuleName(moduleName);
        licenseDetail.setModuleCode(moduleCode);
        licenseDetail.setBankLoginId(bankLoginId);
        licenseDetail.setBankVersion(bankVersionID);
        String userId = RequestContext.get().getUserId();
        licenseDetail.setCreatorid(userId);
        DLock lock = DLock.create((String)EbgLicenseUtil.getCacheKey(), (String)ResManager.loadKDString((String)"\u8bb8\u53ef\u4fdd\u5b58\u5206\u5e03\u5f0f\u9501", (String)"EbgLicenseUtil_5", (String)"ebg-egf-common", (Object[])new Object[0]));
        try {
            if (lock.tryLock()) {
                logger.info("\u7ebf\u7a0b:{}\u6210\u529f\u83b7\u53d6\u9501\uff0c\u5f00\u59cb\u4fdd\u5b58\u8bb8\u53ef\u5360\u7528", (Object)Thread.currentThread().getName());
                licenseDetailService.saveLicenseInfo(licenseDetail);
            }
        }
        catch (Exception e) {
            logger.error("\u8bb8\u53ef\u5360\u7528\u4fdd\u5b58\u5931\u8d25", e);
        }
        finally {
            lock.unlock();
        }
    }

    private static EbgLicenseModuleEnum getEbgLicenseModuleEnum(String subBizType) {
        boolean foreignBank;
        EbgLicenseModuleEnum module = EbgLicenseModuleEnum.PAY;
        if ("receipt".equalsIgnoreCase(subBizType)) {
            module = EbgLicenseModuleEnum.RECEIPT;
        } else if ("balanceStatement".equalsIgnoreCase(subBizType) || "balanceReconciliation".equalsIgnoreCase(subBizType) || "balanceReconciliate".equalsIgnoreCase(subBizType) || "balanceReconciliationQuery".equalsIgnoreCase(subBizType) || "queryBalanceReconciliation".equalsIgnoreCase(subBizType)) {
            module = EbgLicenseModuleEnum.BR;
        } else if (("overseaPay".equalsIgnoreCase(subBizType) || "queryOverseaPay".equalsIgnoreCase(subBizType)) && !(foreignBank = BankVersionRepository.getInstance().isForeignBank(EBContext.getContext().getBankVersionID()))) {
            module = EbgLicenseModuleEnum.CCY_PAY;
        }
        return module;
    }

    public static String checkLicenseValidForNote(String customId, String bankLoginId) {
        if (EbgLicenseUtil.isTestEnv()) {
            return null;
        }
        if (!isCheckLicense) {
            return null;
        }
        TenantInfo tenant = LicenseCache.getTenantForNote();
        int totalLicenseCount = tenant.getTotalLicenseCount();
        if (totalLicenseCount == 0) {
            return EbgLicenseUtil.getLicenseCountZeroForNote();
        }
        LocalDateTime deadline = tenant.getDeadline();
        if (LocalDate.now().compareTo(deadline.toLocalDate()) > 0) {
            return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5e73\u53f0\u8fd4\u56de\u7684\u94f6\u4f01\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u63a5\u53e3\u8bb8\u53ef\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u4e0a\u4f20\u540e\u518d\u91cd\u8bd5\u3002", (String)"EbgLicenseUtil_10", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        int unusedLicenseCount = tenant.getUnusedLicenseCount();
        if (unusedLicenseCount < 0) {
            return ResManager.loadKDString((String)"\u94f6\u4f01\u7684\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u63a5\u53e3\u7684\u8bb8\u53ef\u5206\u7ec4\u6570\u91cf\u5c0f\u4e8e\u5df2\u5360\u7528\u8bb8\u53ef\u6570\u91cf\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u4e1a\u52a1\uff0c\u8bf7\u5728\u8bb8\u53ef\u4fe1\u606f\u4e2d\u67e5\u770b\u8be6\u60c5\u3002", (String)"EbgLicenseUtil_11", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        EBContext context = EBContext.getContext();
        String bankVersionID = context.getBankVersionID();
        LicenseDetailService licenseDetailService = LicenseDetailService.getInstance();
        boolean moduleExist = licenseDetailService.isModuleExist(EbgLicenseModuleEnum.NOTE.getModuleCode(), bankVersionID, customId);
        if (moduleExist) {
            return null;
        }
        if (tenant.getUnusedLicenseCount() < 1) {
            return ResManager.loadKDString((String)"\u94f6\u4f01\u7684\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u63a5\u53e3\u8bb8\u53ef\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u4e1a\u52a1\uff0c\u8bf7\u5728\u8bb8\u53ef\u4fe1\u606f\u4e2d\u67e5\u770b\u8be6\u60c5\u3002", (String)"EbgLicenseUtil_12", (String)"ebg-egf-common", (Object[])new Object[0]);
        }
        EbgLicenseUtil.saveLicenseDetail(customId, bankLoginId, bankVersionID, EbgLicenseModuleEnum.NOTE.getModuleName(), EbgLicenseModuleEnum.NOTE.getModuleCode(), licenseDetailService);
        return null;
    }
}

