/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.license.old;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.license.old.LicenseFileConfigInfo;
import kd.ebg.egf.common.license.old.LicenseFileErrorException;
import kd.ebg.egf.common.license.old.LicenseUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class LicenseFileConfig {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(LicenseFileConfig.class);
    private static final String LICENSEFILE = "licensefile";
    private static final String LICENSEFILE_NAME = "name";
    private static final String LICENSEFILE_URI = "uri";
    private static final String LICENSEFILE_IMPORTDATE = "importdate";
    private static final String LICENSEFILE_ENABLE = "enable";
    private static final String LICENSEFILE_REGISTED = "registed";
    private static final String LICENSEFILE_ID = "licenseID";
    private static final String LICENSEFILE_TRIAL = "isTrial";
    private static final String EDITION_TYPE = "editionType";
    private static final String LICENSEFILE_COUNTER = "counter";
    private static final String LICENSEFILE_INITDATE = "initDate";
    private static final String LICENSEFILE_LASTRUDATE = "lastRunDate";
    private static final String LICENSEFILE_CHECKSUM = "checksum";
    private final String EAS_DEPLOY = "eas.deploy";
    private final String LICENSE_CONFIG_FILE = "licensefile.xml";
    private final String DEFAULT_PATH = "w:/eas/server/deploy/";
    private List _licenseFileList = new ArrayList();
    private Element _elementRoot;
    private String filePath = "";

    public LicenseFileConfig() {
        this.initial();
    }

    public void initial() {
        try {
            this.filePath = System.getProperty("eas.deploy") != null ? System.getProperty("eas.deploy") + "/" + "licensefile.xml" : "w:/eas/server/deploy/licensefile.xml";
            this.parseLicenseFileConfig(this.filePath);
        }
        catch (Throwable e) {
            logger.info("can't read" + this.filePath, (Object)e);
        }
    }

    private void parseLicenseFileConfig(String file) {
        try (FileInputStream input = new FileInputStream(FileCommonUtils.getFileByPath(file));){
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = builder.build((InputStream)input);
            this._elementRoot = doc.getRootElement();
            List licenseFileList = this._elementRoot.getChildren();
            int length = licenseFileList.size();
            for (int i = 0; i < length; ++i) {
                Element ele = (Element)licenseFileList.get(i);
                LicenseFileConfigInfo info = this.parseElement(ele);
                File f = FileCommonUtils.getFileByPath(info.getUri());
                if (!f.exists()) {
                    this.removeFromRootElement(info);
                    try {
                        this.store();
                    }
                    catch (IOException e) {
                        logger.error("\u8bfb\u53d6\u5f02\u5e38", e);
                    }
                    continue;
                }
                if (this._licenseFileList.contains(info)) continue;
                this._licenseFileList.add(info);
            }
        }
        catch (Exception e) {
            logger.error("parse licensefile.xml error!");
        }
    }

    public LicenseFileConfigInfo getLicenseFileCfgInfo(String licenseId) {
        List allLicensFile = this.getlicenseFileList();
        for (LicenseFileConfigInfo info : allLicensFile) {
            String id = info.getFileID();
            if (!licenseId.equals(id)) continue;
            return info;
        }
        return null;
    }

    public LicenseFileConfigInfo parseElement(Element element) {
        assert (element != null);
        LicenseFileConfigInfo info = new LicenseFileConfigInfo();
        String name = element.getChildTextTrim(LICENSEFILE_NAME) == null ? "" : element.getChildTextTrim(LICENSEFILE_NAME);
        String licenseId = element.getChildTextTrim(LICENSEFILE_ID) == null ? "" : element.getChildTextTrim(LICENSEFILE_ID);
        String uri = element.getChildTextTrim(LICENSEFILE_URI) == null ? "" : element.getChildTextTrim(LICENSEFILE_URI);
        String importDate = element.getChildTextTrim(LICENSEFILE_IMPORTDATE) == null ? "" : element.getChildTextTrim(LICENSEFILE_IMPORTDATE);
        String enable = element.getChildTextTrim(LICENSEFILE_ENABLE) == null ? "" : element.getChildTextTrim(LICENSEFILE_ENABLE);
        String registed = element.getChildTextTrim(LICENSEFILE_REGISTED) == null ? "" : element.getChildTextTrim(LICENSEFILE_REGISTED);
        String isTrial = element.getChildTextTrim(LICENSEFILE_TRIAL) == null ? "" : element.getChildTextTrim(LICENSEFILE_TRIAL);
        String editionType = element.getChildTextTrim(EDITION_TYPE) == null ? "" : element.getChildTextTrim(EDITION_TYPE);
        String counter = element.getChildTextTrim(LICENSEFILE_COUNTER) == null ? "" : element.getChildTextTrim(LICENSEFILE_COUNTER);
        String initDate = element.getChildTextTrim(LICENSEFILE_INITDATE) == null ? "" : element.getChildTextTrim(LICENSEFILE_INITDATE);
        String lastRunDate = element.getChildTextTrim(LICENSEFILE_LASTRUDATE) == null ? "" : element.getChildTextTrim(LICENSEFILE_LASTRUDATE);
        String checkSum = element.getChildTextTrim(LICENSEFILE_CHECKSUM) == null ? "" : element.getChildTextTrim(LICENSEFILE_CHECKSUM);
        info.setName(name);
        info.setFileID(licenseId);
        info.setUri(uri);
        info.setImportDate(importDate);
        info.setEnable(Boolean.parseBoolean(enable));
        info.setRegisted(Boolean.parseBoolean(registed));
        info.setTrial(Boolean.parseBoolean(isTrial));
        info.setEditionType(editionType);
        try {
            info.setCounter(LicenseUtil.decryptAES(counter));
            info.setInitDate(LicenseUtil.decryptAES(initDate));
            info.setLastRunDate(LicenseUtil.decryptAES(lastRunDate));
            info.setChecksum(LicenseUtil.decryptAES(checkSum));
        }
        catch (LicenseFileErrorException e) {
            logger.error(e.getMessage(), e);
        }
        return info;
    }

    private synchronized void store() throws IOException {
        try (FileOutputStream fileOut = new FileOutputStream(FileCommonUtils.getFileByPath(this.filePath));){
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(this._elementRoot, (OutputStream)fileOut);
        }
    }

    private synchronized void removeFromRootElement(LicenseFileConfigInfo info) {
        assert (info != null);
        List list = this._elementRoot.getChildren();
        int size = list.size();
        Element eleToRemove = null;
        for (int i = 0; i < size; ++i) {
            Element ele = (Element)list.get(i);
            if (!this.parseElement(ele).equals(info)) continue;
            eleToRemove = ele;
            break;
        }
        if (eleToRemove != null) {
            this._elementRoot.removeContent(eleToRemove);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public List getlicenseFileList() {
        return this._licenseFileList;
    }
}

